<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Http\Controllers\FrameStyleController;
use App\Http\Controllers\OrderStatusController;
use App\Services\CronService;
use Carbon\Carbon;

class AlterFramesTable extends Command
{
    protected $signature = 'alterFramesTable:run';
    protected $description = 'Frame CSV Export';
    public function __construct()
    {
        parent::__construct();
    }
 
    public function handle()
    {
        try {
            $controller = new FrameStyleController();
            $controller->exportFrameDataAsCSV();
            // $this->info('Cron job executed successfully.');
            CronService::log('exportFrameDataAsCSV', '1');
        } catch (\Exception $e) {
            CronService::log('exportFrameDataAsCSV', '0', $e->getMessage());
            $this->error('Code failed: ' . $e->getMessage());
        }

    }
}
