<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Backend\ScheduledCrons;
use App\Services\CronService;

class CronScheduled extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cron:scheduled';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run scheduled crons';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        try {
            $isCron = ScheduledCrons::getNotActive();
            if(!empty($isCron)){
                $isCron->active = 1;
                $isCron->save();
                \Artisan::call('import:csv "rx"');
                $isCron->delete();
            }
            CronService::log($this->signature, '1', $this->description);
        } catch (\Exception $e) {
            CronService::log($this->signature, '0', $e->getMessage());
        }
    }
}
