<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Backend\Order;
use App\Services\CronService;

class DuplicateOrders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'duplicate:orders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run console processes';
    protected $timeout = 0;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        try {
            // Step 1: Find duplicate `invoice_no` values
            $duplicateInvoiceNos = Order::select('invoice_no')
                ->whereNotNull('invoice_no')
                ->where('invoice_no', '<>', '')
                ->where('invoice_no', '<>', '0')
                ->where('status', '<>', 43)
                ->groupBy('invoice_no')
                ->havingRaw('COUNT(*) > 1')
                ->pluck('invoice_no');

            if ($duplicateInvoiceNos->isEmpty()) {
                $this->info("No duplicates found.");
                return;
            }

            // Step 2: Update orders with status 43 for online = 0 in one query
            Order::whereIn('invoice_no', $duplicateInvoiceNos)
                ->where('online', 0)
                ->where('status', '<>', 43) // Ensure only relevant rows are updated
                ->update(['status' => 43]);

            $this->info("Order statuses updated successfully.");
            CronService::log($this->signature, '1', $this->description);
        } catch (\Exception $e) {
            CronService::log($this->signature, '0', $e->getMessage());
            $this->error('Cron job failed: ' . $e->getMessage());
        }
    }
}