<?php

namespace App\Console\Commands;

use App\Custom\Excel\LsWebOrders;
use App\Custom\DropboxComponent;
use Illuminate\Console\Command;
use App\Services\CronService;


class ExportOrders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'export:orders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run console processes';
    protected $timeout = 0;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        try {
            \Excel::store(new LsWebOrders,'public/exports/LsWebOrders.csv','local');
            $fileName = 'LsWebOrders.csv';
            $filePath = storage_path('app/public/exports/'.$fileName);
            DropboxComponent::uploadPdf($filePath, '/' . $fileName, '/lS-hosting/lsweborders');
            CronService::log($this->signature, '1', $this->description);
        } catch (\Exception $e) {
            CronService::log($this->signature, '0', $e->getMessage());
        }
    }
}