<?php

namespace App\Console\Commands;

use App\Models\Backend\RxValidations;
use App\Models\Backend\ImportedConsumablesOrder;
use App\Models\Backend\Stockvalidation;
use Illuminate\Console\Command;
use App\Models\Traits\Import;
use App\Custom\DropboxComponent;
use App\Models\Backend\CreditMemos;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;
use App\Services\CronService;

class ImportCsv extends Command
{
    use Import;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import:csv {type}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import Csv of Customers and all order types.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        try {
            $type = $this->argument('type');
            $signatureWithType = 'import:csv "' . $type . '"';
            Log::info('Cron job started for --'.$type);
            switch ($type) {
                case 'customers':
                    $this->customers();
                break;
                case 'consumable':
                    $result = ImportedConsumablesOrder::import();
                break;
                case 'stock':
                    $result = Stockvalidation::import();
                break;
                case 'rx':
                    $result = RxValidations::import();
                break;
                case 'web_order_status':
                    set_time_limit(7200);
                    $this->webOrderStatus();
                break;
                case 'credit_memos':
                    if (file_exists(public_path(CreditMemos::FILE_PATH_CSV))) {
                        unlink(public_path(CreditMemos::FILE_PATH_CSV));
                    }
                    DropboxComponent::syncDrpboxFiles('/ls-hosting/accessdata','lscreditmemos.csv');

                    CreditMemos::import();
                break;
                case 'ls_web_history':
                    //File 1
                    if (file_exists(public_path('imports/LsWebStatusHistory.csv'))) {
                        unlink(public_path('imports/LsWebStatusHistory.csv'));
                    }
                    DropboxComponent::syncDrpboxFiles('/ls-hosting','LsWebStatusHistory.csv');

                    $destinationPath = '/home/shapers/public_html/incoming/LsWebStatusHistory.csv';
                    $filePath = '/home/shapers/staging.lens-shapers.com/public/imports/LsWebStatusHistory.csv';
                    copy($filePath, $destinationPath);

                    //File 2
                    if (file_exists(public_path('imports/LsWebStatus.csv'))) {
                        unlink(public_path('imports/LsWebStatus.csv'));
                    }
                    DropboxComponent::syncDrpboxFiles('/ls-hosting','LsWebStatus.csv');

                    $destinationPath = '/home/shapers/public_html/incoming/LsWebStatus.csv';
                    $filePath = '/home/shapers/staging.lens-shapers.com/public/imports/LsWebStatus.csv';
                    copy($filePath, $destinationPath);

                    //File 3
                    if (file_exists(public_path('imports/LsWebCustomer.csv'))) {
                        unlink(public_path('imports/LsWebCustomer.csv'));
                    }
                    DropboxComponent::syncDrpboxFiles('/ls-hosting','LsWebCustomer.csv');

                    $destinationPath = '/home/shapers/public_html/incoming/LsWebCustomer.csv';
                    $filePath = '/home/shapers/staging.lens-shapers.com/public/imports/LsWebCustomer.csv';
                    copy($filePath, $destinationPath);
                break;
            }
            Log::info('Cron job ended for --'.$type);
            CronService::log($signatureWithType, '1', $this->description);
        } catch (\Exception $e) {
            CronService::log($signatureWithType ?? $this->signature, '0', $e->getMessage());
        }
    }
}
