<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Carbon\Carbon;
use App\Models\Backend\Notification;
use App\Services\CronService;

class SendNotifications extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send:notifications';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run console processes';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        try {
            $startTime = date('Y-m-d H:i:00',strtotime(date('Y-m-d H:i').' -30 mins'));
            $endTime = date('Y-m-d H:i:59',strtotime(date('Y-m-d H:i').' -30 mins'));
            // $thirtyMinutesAgo = $currentTime->subMinutes(30);
            $notifications = Notification::
                        // where('id',53)//for testing
                        whereBetween('created_at', [$startTime, $endTime])
                        ->get();
            foreach ($notifications as $key => $value) {
                $value->sendEmail();
            }
            CronService::log($this->signature, '1', $this->description);
        } catch (\Exception $e) {
            CronService::log($this->signature, '0', $e->getMessage());
        }
    }
}