<?php

// app/Console/Commands/RunTaskCron.php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Http\Controllers\FrameStyleController;
use App\Services\CronService;
use App\Models\Backend\FrameStyles;
use Spatie\Dropbox\Client;
use Kunnu\Dropbox\Dropbox;
use Spatie\FlysystemDropbox\DropboxAdapter;
use League\Flysystem\Filesystem;

class SyncFramesData extends Command
{
    protected $signature = 'syncFrameData:run';
    protected $description = 'CLI to fetch the data from third party API, sync with database and upload to dropbox as a CSV';
    public function __construct()
    {
        parent::__construct();
    }   

    public function handle()
    {
        try {
            $controller = new FrameStyleController();
            $controller->syncFramesData();
            CronService::log($this->signature, '1', $description);
        } catch (\Exception $e) {
            CronService::log($this->signature, '0', $e->getMessage());
        }
    }
}
