<?php

namespace App\Custom\Traits;

use Codedge\Fpdf\Fpdf\Fpdf;
use App\Models\Backend\Order;
use App\Custom\DropboxComponent;
use App\Models\Backend\RxValidations;

/**
 * Trait UserMethod.
 */
trait PdfMethod
{   
    /**
     * Create RX order pdf
     * 
     * @param App\Models\Order $order;
     */
    public function createRxPdf(Order $order) {

        $rxOrderArray = json_decode($order->rxOrder->data,true);

        $this->AddPage();

        $this->SetLeftMargin(10);
        $this->SetFont('Helvetica','I',16);
        $this->Cell(189,10,'Order Details','B',1,'L');
        
        $this->setRxHeaderInfo($order,$rxOrderArray);
        $this->setRxPrescription($order,$rxOrderArray);
        $this->setRxFrameInfo($order,$rxOrderArray);
        $this->setRxLensInfo($order,$rxOrderArray);
        $this->setRxCoatingInfo($order,$rxOrderArray);
        $this->setRxInstructions($order,$rxOrderArray);

        $fileName = '/rx_order_'.$order->id.'.pdf';
        $filePath = storage_path('app/public/order-pdf'.$fileName);
        $this->Output($filePath, 'F');
        DropboxComponent::uploadPdf($filePath, $fileName,config('access.api.dropbox.order_pdf_upload_path'));
    }

    /**
     * Set header info of order
     * 
     * @param App\Models\Order $order;
     */
    protected function setRxHeaderInfo(Order $order, $rxOrderArray) {

        // Account No.
        $this->setX(10);
        $this->SetFont('Helvetica','',10);
        $this->Cell(45,7,'Account No.',0,'C');
        $this->SetFont('Helvetica','B',10);
        $this->Cell(45,7,$order->user->ac_code,0,'C');

        // Order No.
        $this->setX(90);
        $this->SetFont('Helvetica','',10);
        $this->Cell(45,7,'Web Order No',0,'C');
        $this->setX(130);
        $this->SetFont('Helvetica','B',10);
        $this->Cell(45,7,$order->id,0,'C');
        $this->Ln();

        // Order Date.
        $this->setX(10);
        $this->SetFont('Helvetica','',10);
        $this->Cell(45,7,'Order Date.',0,'C');
        $this->SetFont('Helvetica','B',10);
        $this->Cell(45,7,$order->created_at->toFormattedDateString(),0,'C');
        $this->Ln();

        // Job Type.
        $this->setX(10);
        $this->SetFont('Helvetica','',10);
        $this->Cell(45,7,'Job Type.',0,'C');
        $this->SetFont('Helvetica','B',10);
        $this->Cell(45,7,$order->rxOrder->getJobType($rxOrderArray['frame']['job_type']),0,'C');

        // Status.
        $this->setX(90);
        $this->SetFont('Helvetica','',10);
        $this->Cell(45,7,'Status',0,'C');
        $this->setX(130);
        $this->SetFont('Helvetica','B',10);
        $this->Cell(45,7,$order->statusModel->title,0,'C');
     
    }

    /**
     * Set header info of order
     * 
     * @param App\Models\Order $order;
     */
    protected function setRxPrescription(Order $order, $rxOrderArray) {
       
        // Prescription heading
        $this->SetFillColor(195, 195, 195);
        $this->SetTextColor(0);
        $this->SetLineWidth(.3);
        $this->SetFont('Helvetica','B',8);
        $this->setY(45);
        $this->Cell(189,5,'PRESCRIPTION',1,0,'L', true);
        $this->Ln();

        // Prescription details
        $this->setY(55);
        $this->Rect(10,50,189,38);
        $this->SetFillColor(236,236,218);
        $this->SetTextColor(0);
        $this->SetLineWidth(.3);
        $this->SetFont('Helvetica','',8);
        $this->setY(50.4);
        $this->setX(10.5);
        $this->Cell(40,5,'Patient/Reference',0,0,'L', true);
        $this->SetFont('Helvetica','B',8);
        $this->Cell(40,5,$rxOrderArray['first_name'] . ' ' . $rxOrderArray['last_name'],0,0,'L');
        $this->Ln();

        $distanceAttributes = ['Sph','Cyl','Axis','Prism 1','Base 1','Prism 2','Base 2'];
        $this->setY(55.5);
        $this->setX(40);
        $this->SetFont('Helvetica','',8);
        $this->SetFillColor(236,236,218);
        for ($i=0; $i < count($distanceAttributes) ; $i++) { 
            $this->Cell(20,5,$distanceAttributes[$i],0,0,'C', true);
        }
        $this->Ln();

        // Distnace
        $this->setY(61);
        $this->SetFont('Helvetica','',8);
        $this->Cell(24,5,'Distant',0,0,'C');
        $this->SetFillColor(236,236,218);
        $this->Cell(6,5,'R',0,0,'C', true);
        $this->SetFont('Helvetica','B',10);

        $rxDistanceValues = [
            $rxOrderArray['rx']['distance']['right_sph'],
            $rxOrderArray['rx']['distance']['right_cyl'],
            $rxOrderArray['rx']['distance']['right_axis'],
            $rxOrderArray['rx']['prism']['right_prism1'],
            $rxOrderArray['rx']['prism']['right_base1'],
            $rxOrderArray['rx']['prism']['right_prism2'],
            $rxOrderArray['rx']['prism']['right_base2'],
        ];
        $this->setX(40);
        for ($i=0; $i < count($rxDistanceValues); $i++) { 
            $this->Cell(20,5,$rxDistanceValues[$i],0,0,'C');
        }
        $this->Ln();

        // Vision
        $this->SetFont('Helvetica','',8);
        $this->Cell(24,5,'Vision ',0,0,'C');
        $this->SetFillColor(236,236,218);
        $this->Cell(6,5,'L',0,0,'C', true);
        $this->SetFont('Helvetica','B',10);

        $rxDistanceValues = [
            $rxOrderArray['rx']['distance']['left_sph'],
            $rxOrderArray['rx']['distance']['left_cyl'],
            $rxOrderArray['rx']['distance']['left_axis'],
            $rxOrderArray['rx']['prism']['left_prism1'],
            $rxOrderArray['rx']['prism']['left_base1'],
            $rxOrderArray['rx']['prism']['left_prism2'],
            $rxOrderArray['rx']['prism']['left_base2'],
        ];

        $this->setX(40);
        for ($i=0; $i < count($rxDistanceValues); $i++) { 
            $this->Cell(20,5,$rxDistanceValues[$i],0,0,'C');
        }
        $this->Ln();

        $readingAttributes = ['Add','Seg Height','Dist PD','Near PD','Base Curve'];

        $this->setY(71.5);
        $this->setX(40);
        $this->SetFont('Helvetica','',8);
        $this->SetFillColor(236,236,218);
        for ($i=0; $i < count($readingAttributes) ; $i++) { 
            $this->Cell(20,5,$readingAttributes[$i],0,0,'C', true);
        }
        $this->Ln();

        $this->setY(77);
        $this->SetFont('Helvetica','',8);
        $this->Cell(24,5,'Reading',0,0,'C');
        $this->SetFillColor(236,236,218);
        $this->Cell(6,5,'R',0,0,'C', true);
        $this->SetFont('Helvetica','B',10);

        $rxReadingValues = [
            $rxOrderArray['rx']['add_for_reading']['right_add'],
            $rxOrderArray['rx']['add_for_reading']['right_sh'],
            $rxOrderArray['rx']['add_for_reading']['right_intermediate_strength'],
            $rxOrderArray['rx']['add_for_reading']['right_boc'],
            $rxOrderArray['rx']['extended_info']['right_pd'],
        ];

        $this->setX(40);
        for ($i=0; $i < count($rxReadingValues); $i++) { 
            $this->Cell(20,5,$rxReadingValues[$i],0,0,'C');
        }
        $this->Ln();

        $this->setX(34);
        $this->SetFillColor(236,236,218);
        $this->SetFont('Helvetica','',10);
        $this->Cell(6,5,'L',0,0,'C', true);
        $this->SetFont('Helvetica','B',10);

        $rxReadingLeftValues = [
            $rxOrderArray['rx']['add_for_reading']['left_add'],
            $rxOrderArray['rx']['add_for_reading']['left_sh'],
            $rxOrderArray['rx']['add_for_reading']['left_intermediate_strength'],
            $rxOrderArray['rx']['add_for_reading']['left_boc'],
            $rxOrderArray['rx']['extended_info']['left_pd'],
        ];

        $this->setX(40);
        for ($i=0; $i < count($rxReadingLeftValues); $i++) { 
            $this->Cell(20,5,$rxReadingLeftValues[$i],0,0,'C');
        }
        $this->Ln();
    }

    /**
     * Set Job/Frame info of order
     * 
     * @param App\Models\Order $order;
     */
    protected function setRxFrameInfo(Order $order, $rxOrderArray) {
        
        // Job/Frame heading
        $this->SetFillColor(195, 195, 195);
        $this->SetTextColor(0);
        $this->SetLineWidth(.3);
        $this->SetFont('Helvetica','B',8);
        $this->setY(90);
        $this->Cell(189,5,'JOB / FRAME INFORMATION',1,0,'L', true);
        $this->Ln();

        // Job/Frame details
        $this->setY(100);
        $this->Rect(10,90,189,56);
        $this->SetFillColor(236,236,218);
        $this->SetTextColor(0);
        $this->SetLineWidth(.3);
        $this->SetFont('Helvetica','',8);
        $this->setY(95.3);
        $this->setX(10.5);
        $this->Cell(30,5,'Job Type','',0,'L', true);
        $this->setX(40);
        $this->SetFont('Helvetica','B',8);
        $this->Cell(30,5,$order->rxOrder->getJobType($rxOrderArray['frame']['job_type']),'',0,'L');
        $this->Ln();

        $this->SetFillColor(236,236,218);
        $this->SetTextColor(0);
        $this->SetLineWidth(.3);
        $this->SetFont('Helvetica','',8);
        $this->setY(101);
        $this->setX(10.5);
        $this->Cell(30,5,'Frame Type','',0,'L', true);
        $this->setX(40);
        $this->SetFont('Helvetica','B',8);
        $this->Cell(30,5,$order->rxOrder->getFrameType($rxOrderArray['frame']['frame_type']),'',0,'L');
        $this->Ln();

        $this->setY(106.4);
        $this->setX(10.4);
        $this->Rect(10,106,94.5,20);
        $this->SetFont('Helvetica','',8);
        $this->Cell(94,5,'Frame Size','',0,'C', true);
        $this->Ln();


        $frameSizes = ['A', 'B', 'ED', 'DBL'];

        $this->setY(108);
        $this->setX(10.4);
        $this->SetFont('Helvetica','',10);
        $this->SetFillColor(236,236,218);
        for ($i=0; $i < count($frameSizes) ; $i++) { 
            $this->Cell(24,12,$frameSizes[$i],0,0,'C');
        }
        $this->Ln();

        $frameSizeValues = [
            isset($rxOrderArray['frame']['a']) ? $rxOrderArray['frame']['a'] : '',
            isset($rxOrderArray['frame']['a']) ? $rxOrderArray['frame']['a'] : '',
            isset($rxOrderArray['frame']['ed']) ? $rxOrderArray['frame']['ed'] : '',
            isset($rxOrderArray['frame']['dbl']) ? $rxOrderArray['frame']['dbl'] : ''
        ];

        $this->setY(110);
        $this->setX(10.4);
        $this->SetFont('Helvetica','B',10);
        for ($i=0; $i < count($frameSizeValues) ; $i++) { 
            $this->Cell(24,17,$frameSizeValues[$i],0,0,'C');
        }
        $this->Ln();

        $this->setY(106.4);
        $this->setX(10.4);
        $this->Rect(104.5,106,94.5,20);
        $this->SetFont('Helvetica','',8);
        $this->Cell(94,5,'Frame Size','',0,'C', true);
        $this->Ln();

        $frameInfo = ['Frame Brand', 'Frame Model', 'Frame Colour', 'Frame POF'];

        $this->setY(106.4);
        $this->SetFont('Helvetica','',10);
        $this->SetFillColor(236,236,218);
        for ($i=0; $i < count($frameInfo) ; $i++) { 
            $this->setX(105);
            $this->Cell(24,4.8,$frameInfo[$i],0,0,'L', true);
            $this->Ln();
        }

        $frameInfoValues = [
            isset($rxOrderArray['rx']['extended_info']['left_brand']) ? $rxOrderArray['rx']['extended_info']['left_brand'] : '',
            isset($rxOrderArray['rx']['extended_info']['left_model']) ? $rxOrderArray['rx']['extended_info']['left_model'] : '',
            isset($rxOrderArray['rx']['extended_info']['left_colour']) ? $rxOrderArray['rx']['extended_info']['left_colour'] : '',
            isset($rxOrderArray['frame']['frame_info']['pof']) ? $rxOrderArray['frame']['frame_info']['pof'] : ''
        ];

        $this->setY(106.4);
        $this->SetFont('Helvetica','B',10);
        for ($i=0; $i < count($frameInfoValues) ; $i++) { 
            $this->setX(150);
            $this->Cell(24,4.8,$frameInfoValues[$i],0,0,'L');
            $this->Ln();
        }

        $this->setY(126);
        $this->setX(10.4);
        $this->Rect(10,126,94.5,20);
        $this->SetFont('Helvetica','',8);
        $this->Cell(94,5,'Modify Shape','',0,'C', true);
        $this->Ln();

        $modifyShape = ['A', 'B'];

        $this->setY(134);
        for ($i=0; $i < count($modifyShape); $i++) { 
            $this->setX(10);
            $this->Cell(24,4.8,$modifyShape[$i],0,0,'L');
            $this->Ln();
        }

        $modifyShapeValues = [
            isset($rxOrderArray['frame']['modify_shape']['ms_a']) ? $rxOrderArray['frame']['modify_shape']['ms_a'] : '',
            isset($rxOrderArray['frame']['modify_shape']['ms_b']) ? $rxOrderArray['frame']['modify_shape']['ms_b'] : ''
        ];

        $this->setY(134);
        for ($i=0; $i < count($modifyShape); $i++) { 
            $this->setX(45);
            $this->Cell(24,4.8,'Test modify shape',0,0,'L');
            $this->Ln();
        }

        $this->setY(126);
        $this->setX(105);
        $this->SetFont('Helvetica','',8);
        $this->Cell(94,5,'Thickness','',0,'C', true);
        $this->Ln();

        $this->setY(134);
        $this->setX(105);
        $this->SetFont('Helvetica','B',10);
        $this->Cell(94,5,isset($rxOrderArray['rx']['specify_thickness']) ? $rxOrderArray['rx']['specify_thickness'] : '','',0,'C');
        $this->Ln();
    }

    /**
     * Set header info of order
     * 
     * @param App\Models\Order $order;
     * @param $rxOrderArray;
     */
    protected function setRxLensInfo(Order $order, $rxOrderArray) {
        // Job/Frame heading
        $this->SetFillColor(195, 195, 195);
        $this->SetTextColor(0);
        $this->SetLineWidth(.3);
        $this->SetFont('Helvetica','B',8);
        $this->setY(148);
        $this->Cell(94.5,5,'LENS INFORMATION',1,0,'L', true);
        $this->Ln();

        // Job/Frame heading
        $this->SetFillColor(195, 195, 195);
        $this->SetTextColor(0);
        $this->SetLineWidth(.3);
        $this->SetFont('Helvetica','B',8);
        $this->setY(148);
        $this->setX(104.5);
        $this->Cell(94.6,5,'COATINGS & TREATMENTS',1,0,'L', true);
        $this->Ln();

        // Job/Frame details
        $this->setY(148);
        $this->Rect(10,148,94.5,35);
        $this->SetFillColor(236,236,218);
        $this->SetTextColor(0);
        $this->SetLineWidth(.3);

  
        $lensInfoArray = ['Lens','Material','Colour Type','Colour','Stock Coating'];
        $this->setY(153.3);
        $this->SetFont('Helvetica','',9);
        $this->SetFillColor(236,236,218);
        for ($i=0; $i < count($lensInfoArray); $i++) { 
            $this->setX(10.5);
            $this->Cell(24,4.8,$lensInfoArray[$i],0,0,'L', true);
            $this->Ln();
        }

        $this->setY(153.3);
        $this->setX(30.5);
        $this->SetFont('Helvetica','',9);

        $rxValidation = new RxValidations;
        $lensType = null;

        if (is_array($rxOrderArray['lens']['lens_type'])) {
            if (isset($rxOrderArray['lens']['lens_type']['sv'])) {
                $lensType = $rxValidation->decodeValue($rxOrderArray['lens']['lens_type']['sv']);
            } elseif ($rxOrderArray['lens']['lens_type']['progressive']) {
                $lensType = $rxValidation->decodeValue($rxOrderArray['lens']['lens_type']['progressive']);
            }
        } else {
            $lensType = $rxValidation->decodeValue($rxOrderArray['lens']['lens_type']);
        }

        $lensInfoValues = [
            $lensType,
            isset($rxOrderArray['lens']['lens_material']) ? $rxValidation->decodeValue($rxOrderArray['lens']['lens_material']) : '',
            isset($rxOrderArray['lens']['lens_colour']) ? $rxValidation->decodeValue($rxOrderArray['lens']['lens_colour']) : '',
            isset($rxOrderArray['lens']['lens_material']) ? $rxValidation->decodeValue($rxOrderArray['lens']['lens_material']) : '',
            isset($rxOrderArray['lens']['coating_made']) ? $rxValidation->decodeValue($rxOrderArray['lens']['coating_made']) : ''
        ];

        $this->setY(153.3);
        $this->SetFont('Helvetica','',9);
        for ($i=0; $i < count($lensInfoValues); $i++) { 
            $this->setX(35);
            $this->Cell(24,4.8,$lensInfoValues[$i],0,0,'L');
            $this->Ln();
        }
    }

    /**
     * Set header info of order
     * 
     * @param App\Models\Order $order;
     * @param $rxOrderArray;
     */
    protected function setRxCoatingInfo(Order $order, $rxOrderArray) {
        $rxValidation = new RxValidations;
        
        // Job/Frame details
        $this->setY(148);
        $this->Rect(104.5,148,94.5,35);
        $this->SetFillColor(236,236,218);
        $this->SetTextColor(0);
        $this->SetLineWidth(.3);

        $coatingInfoArray = ['Manufacturer','Coating'];
        
        $this->setY(153.3);
        $this->SetFont('Helvetica','',9);
        $this->SetFillColor(236,236,218);
        for ($i=0; $i < count($coatingInfoArray); $i++) { 
            $this->setX(105);
            $this->Cell(24,4.8,$coatingInfoArray[$i],0,0,'L', true);
            $this->Ln();
        }

        $lensCoatingValues = [
            $rxValidation->decodeValue($rxOrderArray['lens']['coating_made']),
            $rxValidation->decodeValue($rxOrderArray['lens']['coating_name'])
        ];

        $this->setY(153.3);
        $this->SetFont('Helvetica','',9);
        for ($i=0; $i < count($lensCoatingValues); $i++) { 
            $this->setX(145);
            $this->Cell(24,4.8,$lensCoatingValues[$i],0,0,'L');
            $this->Ln();
        }
    }

    /**
     * Set header info of order
     * 
     * @param App\Models\Order $order;
     * @param $rxOrderArray;
     */
    protected function setRxInstructions(Order $order, $rxOrderArray) {

            // Job/Frame heading
            $this->SetFillColor(195, 195, 195);
            $this->SetTextColor(0);
            $this->SetLineWidth(.3);
            $this->SetFont('Helvetica','B',8);
            $this->setY(185);
            $this->setX(10);
            $this->Cell(189,5,'SPECIAL INSTRUCTIONS',1,0,'L', true);
            $this->Ln();

            // Job/Frame details
            $this->setY(155);
            $this->Rect(10,185,189,35);
            $this->SetFillColor(236,236,218);
            $this->SetTextColor(0);
            $this->SetLineWidth(.3);

            $this->setY(192);
            $this->SetFont('Arial','',10);
            $this->Write(4,$rxOrderArray['special_instructions']);

    }
}
