<?php

use App\Helpers\General\HtmlHelper;

if (! function_exists('style')) {
    /**
     * @param       $url
     * @param array $attributes
     * @param null  $secure
     *
     * @return mixed
     */
    function style($url, $attributes = [], $secure = null)
    {
        return resolve(HtmlHelper::class)->style($url, $attributes, $secure);
    }
}

if (! function_exists('script')) {
    /**
     * @param       $url
     * @param array $attributes
     * @param null  $secure
     *
     * @return mixed
     */
    function script($url, $attributes = [], $secure = null)
    {
        return resolve(HtmlHelper::class)->script($url, $attributes, $secure);
    }
}

if (! function_exists('form_cancel')) {
    /**
     * @param        $cancel_to
     * @param        $title
     * @param string $classes
     *
     * @return mixed
     */
    function form_cancel($cancel_to, $title, $classes = 'btn red')
    {
        return resolve(HtmlHelper::class)->formCancel($cancel_to, $title, $classes);
    }
}

if (! function_exists('form_submit')) {
    /**
     * @param        $title
     * @param string $classes
     *
     * @return mixed
     */
    function form_submit($title, $classes = 'btn blue')
    {
        return resolve(HtmlHelper::class)->formSubmit($title, $classes);
    }
}

if (! function_exists('form_save')) {
    /**
     * @param        $title
     * @param string $classes
     *
     * @return mixed
     */
    function form_save($title, $classes = 'btn blue')
    {
        return resolve(HtmlHelper::class)->formSave($title, $classes);
    }
}

if (! function_exists('form_button')) {
    /**
     * @param        $title
     * @param string $classes
     *
     * @return mixed
     */
    function form_button($cancel_to, $title, $classes = 'btn red')
    {
        return resolve(HtmlHelper::class)->formButton($cancel_to, $title, $classes);
    }
}
