<?php

namespace App\Http\Composers\Backend;

use Illuminate\View\View;
use App\Models\Auth\User;
use App\Models\Backend\Notification;
use App\Models\Backend\UserNotification;

/**
 * Class SidebarComposer.
 */
class HeaderComposer
{
    /**
     * @var Notification
     */
    protected $notification;
    

    /**
     * @var User
     */
    protected $user;

    /**
     * HeaderComposer constructor.
     *
     * @param Notification $notification
     * @param User $user
     */
    public function __construct(Notification $notification, User $user)
    {
        $this->notification = $notification;
        $this->user = $user;
    }

    /**
     * @param View $view
     *
     * @return bool|mixed
     */
    public function compose(View $view)
    {
        $view->with('notifications', $this->user->notifications());
        $view->with('unreadNotifications', $this->user->unreadNotifications());
    }
}