<?php

namespace App\Http\Composers;

use Illuminate\View\View;

/**
 * Class GlobalComposer.
 */
class GlobalComposer
{
    /**
     * Bind data to the view.
     *
     * @param View $view
     */
    public function compose(View $view)
    {
        $loggedInUser = auth()->user();
        $type = null;

        if ($loggedInUser) {
            $type = $loggedInUser->can('view backend') ? 'backend' : 'frontend';
        }

        $view->with('logged_in_user', $loggedInUser);
        $view->with('portalType', $type);
    }
}
