<?php

namespace App\Http\Controllers;

use Fpdf;
use Spatie\Dropbox\Client;
use Kunnu\Dropbox\Dropbox;
use App\Custom\PdfComponent;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Http;
use Kunnu\Dropbox\DropboxApp;
use Kunnu\Dropbox\DropboxFile;
use App\Custom\DropboxComponent;
use League\Flysystem\Filesystem;
use Spatie\FlysystemDropbox\DropboxAdapter;
use App\Models\Backend\RxValidations;

/**
 * Class ApiController.
 */
class ApiController extends Controller
{
    public function dropbox(): JsonResponse
    {
        DropboxComponent::syncDrpboxFiles();
        return response()->json(['Dropbox sync completed.']);
    }

    public function api(): JsonResponse
    {
        $url = 'https://api.dropboxapi.com/2/file_requests/list_v2';

        $response = Http::withToken(config('access.api.dropbox.auth_token'))
            ->post($url, ['limit' => 1000]);

        if ($response->successful()) {
            return response()->json($response->json());
        } else {
            return response()->json(['error' => 'API request failed'], 500);
        }
    }
}