<?php

namespace App\Http\Controllers\Backend\Auth;

use App\Models\Auth\User;
use Illuminate\Http\Request;
use App\Models\Backend\PhoneLog;
use App\Http\Controllers\Controller;
use App\Events\Frontend\Auth\CustomerInquiryLog;
use App\Http\Requests\Frontend\Auth\StorePhoneLogRequest;

class PhoneLogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $logs = PhoneLog::getPhonelogs($request['type'],$request['order_id']);
            return view('backend.auth.orders.includes.logs-modal')
                ->withLogs($logs)->withSingle(false);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StorePhoneLogRequest $request)
    {
        $user = auth()->user();
        if ($request->ajax()) {
            $logs = PhoneLog::store($request->all());
            if ($logs) {
                event(new CustomerInquiryLog($logs));
                return view('backend.auth.orders.includes.logs-modal')
                    ->withLogs($logs)->withSingle(true);
            } 
        }
    }
}
