<?php

namespace App\Http\Controllers\Backend\Auth;

use Carbon\Carbon;

use Illuminate\Http\Request;
use Validator;
use App\Http\Controllers\Controller;
use App\Models\Backend\ReligionsList;

class ReligionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function listApi(Request $request)
    {
        if($request->ajax()){
            $list = ReligionsList::getList();
            return view('backend.auth.orders.includes.tabs.religions-table')
                ->withList($list);
        }
    } 
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if($request->ajax()){
            $post = $request->all();
            $validator = Validator::make($request->all(), [
                'name'          =>  ['required','unique:religions_list,name']
            ]);
            
            if($validator->fails()){
                return response()->json(['status'=>false,'message'=>$this->validationErrorsToString($validator->errors()->toArray())]);  
            }
            $post['label'] = $post['name'];
            $post['status'] = 1;
            ReligionsList::create($post);
            return response()->json(['status'=>true,'message'=>'Religon was added successfully']);
        }
        return response()->json(['status'=>false,'message'=>'Something went wrong']);
    }   

    public function updateStatus(Request $request)
    {
        $modal = ReligionsList::findOrFail($request->id);
        $modal->status = $request->status;
        if($modal->save()){
            return response()->json(['status'=>true,'message'=>'Status was updated successfully']);
        }
        return response()->json(['status'=>false,'message'=>'Something went wrong']);
    }

    public function destroy(Request $request)
    {
        $modal = ReligionsList::findOrFail($request->id);
        if($modal->delete()){
            return response()->json(['status'=>true,'message'=>'Status was deleted successfully']);
        }
        return response()->json(['status'=>false,'message'=>'Something went wrong']);
    }

    public function update($id,Request $request)
    {
        $modal = ReligionsList::findOrFail($id);
        $modal->name = $request->value;
        if($modal->save()){
            return response()->json([ 'code'=>200,'pk'=>$id,'value'=>$modal->name], 200);
        }
        return response()->json([ 'error'=> 400, 'message'=> 'Not enought params' ], 400);
    }
}
