<?php

namespace App\Http\Controllers\Backend\Auth\User;

use Illuminate\Http\Request;
use App\Models\Backend\Order;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\NotificationsTrait;
use App\Models\Backend\UserSettings;
use App\Models\Backend\Notification;
use App\Models\Backend\PhoneLog;

class AccountController extends Controller
{
    use NotificationsTrait;

    /**
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index()
    {
        // Get last five latest orders and show on admin profile page
        $orders = Order::orderBy('id', 'asc')->take(5)->get();
        $user = auth()->user();
        $profile = auth()->user()->profile;

        $settings = new UserSettings();
        if(!empty($user->userSettings))
            $settings = $user->userSettings;

        return view('backend.auth.user.account')
            ->withUser($user)
            ->withOrders($orders)
            ->withProfile($profile)
            ->withSettings($settings);
    }

    /**
     * @return \Illuminate\View\View
     */
    public function notifications(Request $request)
    {
        $data = $this->getNotificationsData($request);
        if ($request->ajax()) {
            return view('backend.notifications', $data);
        }
        return view('backend.notifications', $data);
    }
}
