<?php

namespace App\Http\Controllers\Backend\Auth\User;

use App\Models\Auth\User;
use Illuminate\Http\Request;
use App\Models\Backend\UserProfile;
use App\Http\Controllers\Controller;
use App\Repositories\Backend\Auth\UserRepository;
use App\Http\Requests\Backend\Auth\User\UpdateProfileRequest;

/**
 * Class ProfileController.
 */
class ProfileController extends Controller
{
    /**
     * @var UserRepository
     */
    protected $userRepository;

    /**
     * ProfileController constructor.
     *
     * @param UserRepository $userRepository
     */
    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    /**
     * @param UpdateProfileRequest $request
     *
     * @throws \App\Exceptions\GeneralException
     * @return mixed
     */
    public function update(UpdateProfileRequest $request, User $user)
    {
        if($request->get('steps') == 'personal_info'){
            $output = $this->userRepository->update(
                $request->user(),
                $request->all()
            );
        }elseif($request->get('steps') == 'avatar'){
            $output = $this->userRepository->updateAvatar(
                $request->user(),
                $request->all(),
                $request->has('avatar_location') ? $request->file('avatar_location') : false
            );
        }elseif($request->get('steps') == 'settings'){
            $output = $this->userRepository->updateSettings(
                $request->user(),
                $request->all()
            );
        }else{
            return redirect()->route('admin.user.account')->withFlashDanger('Profile is not updated!');
        }
        return redirect()->route('admin.user.account')->withFlashSuccess(__('strings.frontend.user.profile_updated'));
    }
}
