<?php

namespace App\Http\Controllers\Frontend\Auth;

use Illuminate\Http\Request;
use Illuminate\View\View;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use App\Models\Backend\CreditMemos;

/**
 * Class CreditMemosController.
 */
class CreditMemosController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return View
     */
    public function index(Request $request): View
    {
        $creditMemos = CreditMemos::getData();
        $creditMemos = collect($creditMemos)->sortByDesc('credit_number')->values()->all();
        return view('frontend.credit-memos.index', ['creditMemos' => $creditMemos]);
    }

    /**
     * Get File.
     *
     * @return Response
     */
    public function file(Request $request): Response
    {
        $file = CreditMemos::getFile($request->get('id'));
        return $file;
    }
}