<?php

namespace App\Http\Controllers\Frontend\Auth;

use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Models\Backend\Notification;

/**
 * Class NotificationController.
 */
class NotificationController extends Controller
{
    /**
     * @var Notification
     */
    protected Notification $notification;

    /**
     * UserController constructor.
     *
     * @param Notification $notification
     */
    public function __construct(Notification $notification)
    {
        $this->notification = $notification;
    }

    /**
     * customer reads all notifications
     *
     * @param Request $request
     *
     * @return JsonResponse|null
     */
    public function customerReadsAllNotifications(Request $request): ?JsonResponse
    {
        if ($request->ajax()) {
            $readAllNotifications = $this->notification->readAll();
            if ($readAllNotifications) {
                return response()->json($readAllNotifications);
            }
        }

        return null;
    }
}