<?php

namespace App\Http\Controllers\Frontend\Auth;

use App\Http\Controllers\Controller;
use App\Repositories\Frontend\Auth\UserRepository;
use App\Http\Requests\Frontend\User\UpdatePasswordRequest;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;

/**
 * Class PasswordExpiredController.
 */
class PasswordExpiredController extends Controller
{
    /**
     * @return View
     */
    public function expired(): View
    {
        abort_unless(config('access.users.password_expires_days'), 404);

        return view('frontend.auth.passwords.expired');
    }

    /**
     * @param UpdatePasswordRequest $request
     * @param UserRepository        $userRepository
     *
     * @throws \App\Exceptions\GeneralException
     * @return RedirectResponse
     */
    public function update(UpdatePasswordRequest $request, UserRepository $userRepository): RedirectResponse
    {
        abort_unless(config('access.users.password_expires_days'), 404);
        $userRepository->updatePassword($request->only('old_password', 'password'), true);

        return redirect()->route('frontend.user.account')
            ->withFlashSuccess(__('strings.frontend.user.password_updated'));
    }
}