<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;
use App\Mail\Frontend\Contact\SendContact;
use App\Http\Requests\Frontend\Contact\SendContactRequest;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;

/**
 * Class ContactController.
 */
class ContactController extends Controller
{
    /**
     * @return View
     */
    public function index(): View
    {
        return view('frontend.contact');
    }

    /**
     * @param SendContactRequest $request
     *
     * @return RedirectResponse
     */
    public function send(SendContactRequest $request): RedirectResponse
    {
        Mail::send(new SendContact($request));

        return redirect()->back()->withFlashSuccess(__('alerts.frontend.contact.sent'));
    }
}