<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Artisan;
use App\Models\Auth\User;

/**
 * Class HomeController.
 */
class HomeController extends Controller
{
    /**
     * @return RedirectResponse
     */
    public function index(): RedirectResponse
    {
        return redirect()->route('login');
    }

    public function validateAuth(Request $request): JsonResponse
    {
        if ($request->ajax() && Auth::check()) {
            return response()->json(['status' => true]);
        }
        return response()->json(['status' => false]);
    }

    /**
     * Display the specified resource.
     *
     * @param string $id
     * @param string $type
     * @return JsonResponse
     */
    public function detailsApi(string $id, string $type): JsonResponse
    {
        $response = [
            'order' => '',
            'meta_data' => []
        ];
        $userModel = User::find($id);
        if ($userModel) {
            $response = match ($type) {
                'users' => [
                    'order' => view('frontend.user.account.tabs.overview')
                        ->withUser($userModel)
                        ->withProfile($userModel->profile)
                        ->render(),
                    'meta_data' => [
                        'id' => $id,
                        'permission_order_placed' => $userModel->permission_order_placed,
                        'permission_prices_invoices' => $userModel->permission_prices_invoices,
                    ],
                ],
                default => $response,
            };
        }
        return response()->json($response);
    }

    public function runImport(): JsonResponse
    {
        $command = 'import:csv';
        $parameter = 'ls_web_history';
        $exitCode = Artisan::call($command, ['type' => $parameter]);

        if ($exitCode === 0) {
            return response()->json(['message' => 'Command executed successfully']);
        } else {
            return response()->json(['message' => 'Command execution failed'], 500);
        }
    }
}