<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Models\Backend\OrderStatus;

/**
 * Class OrderStatusController.
 */
class OrderStatusController extends Controller
{
    public function index(): JsonResponse
    {
        return response()->json(['orderstatus' => OrderStatus::orderBy('sorting', 'asc')->get()]);
    }

    public function updateColor(Request $request): JsonResponse
    {
        $order = OrderStatus::find($request->orderId);
        $order->color = $request->newColor;
        $order->save();
        return response()->json(['success' => true]);
    }

    public function setOrderStatusTableSorting(): void
    {
        $table = OrderStatus::all();
        foreach ($table as $key => $value) {
            OrderStatus::where('id', $value->id)->update(['sorting' => $key + 1]);
        }
    }

    public function updateSortingOrder(Request $request): JsonResponse
    {
        collect($request->order)->each(function ($item) {
            OrderStatus::where('id', $item['id'])->update(['sorting' => $item['sort_order']]);
        });
        return response()->json(['message' => 'Sorting order updated successfully']);
    }
}