<?php

namespace App\Http\Middleware;

use Closure;

/**
 * Class RedirectIfAuthenticated.
 */
class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string|null  $guard
     * @return mixed
     */
    public function handle($request, Closure $next, $guard = null)
    {
        if (auth()->guard($guard)->check()) {
            if(auth()->user()->can('view backend')){
                return redirect()->route('admin.orders.list');
            }elseif(auth()->user()->can('view frontend')){
                if(auth()->user()->can('frontend admin'))
                    return redirect()->route('frontend.user.orders');
                
                return redirect()->route('frontend.user.common.dashboard');
            }
            return redirect()->route(home_route());
        }

        return $next($request);
    }
}
