<?php
 
namespace App\Http\Middleware;
 
use Closure;
 
class RevalidateBackHistory
{
	 /**
	 * Handle an incoming request.
	 *
	 * @param \Illuminate\Http\Request $request
	 * @param \Closure $next
	 * @return mixed
	 */
	public function handle($request, Closure $next)
	{
		if ($this->shouldSkip($request)) {
            return $next($request);
        }
        
		 $response = $next($request);
		  
		 return $response->header('Cache-Control','nocache, no-store, max-age=0, must-revalidate')
		 ->header('Pragma','no-cache')
		 ->header('Expires','Fri, 01 Jan 1990 00:00:00 GMT');
	}
	protected function shouldSkip($request)
    {
        // List of routes to exclude by path or name
        $excludedRoutes = [
            'frontend.files.statements',
            'frontend.files.invoice',
            'frontend.files.credit-memos',
            'frontend.files.others',
            'frontend.files.orders'
        ];

        // Check if the current route is in the excluded list
        return in_array($request->path(), $excludedRoutes) ||
               in_array($request->route()->getName(), $excludedRoutes);
    }
}
