<?php

namespace App\Http\Requests\Backend\Auth\User;

use Illuminate\Validation\Rule;
use App\Helpers\Auth\SocialiteHelper;
use Illuminate\Foundation\Http\FormRequest;

/**
 * Class UpdateProfileRequest.
 */
class UpdateProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->isAcessible(['view backend']);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [];

        if($this->request->get('steps') == 'personal_info'){
            $rules = [
                'first_name' => ['required', 'max:191'],
                'last_name' => ['required', 'max:191'],
                'email' => ['sometimes', 'required', 'email', 'max:191'],
            ];
        }elseif($this->request->get('steps') == 'avatar'){
            $rules = [
                'avatar_type' => [
                    'required',
                    'max:191',
                    Rule::in(array_merge(['gravatar', 'storage'],
                    (new SocialiteHelper)->getAcceptedProviders()))
                ],
                'avatar_location' => [
                    'sometimes',
                    'file',
                    'max:2048',
                    'mimes:jpeg,png,jpg,gif,webp',
                ],
            ];
        }
        return $rules;
    }
}
