<?php

namespace App\Http\Requests\Frontend\Auth;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class StoreConsumableOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth()->user()->isAcessible(['frontend admin']);

    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        return [
            'quantity'      =>  ['required'],
            'confirm_order' =>  ['required'],
            'id'            =>  ['required'],
        ];
    }
}
