<?php

namespace App\Http\Requests\Frontend\Auth;

use App\Models\Backend\StockOrder;
use Illuminate\Foundation\Http\FormRequest;

class StoreStockOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return (auth()->user()->isAcessible(['frontend admin']) && auth()->user()->isStockUser()) || auth()->user()->isOrderPlacedPermission();

    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if($this->request->get('combinition') == StockOrder::LEFT_EYE) {
            $rules = [
                'patient'       =>  ['required', 'max:191'],
                'l_material'    =>  ['required', 'max:191'],
                'l_colour'      =>  ['required', 'max:191'],
                'l_coating'     =>  ['required', 'max:191'],
                'l_sph'         =>  ['required', 'max:191'],
                'l_cyl'         =>  ['required', 'max:191'],
                // 'l_size'        =>  ['required', 'max:191'],
                'l_quantity'    =>  ['required', 'max:191'],
                // 'l_price'       =>  ['required', 'max:191'],
            ];
            return $rules;
        } elseif ($this->request->get('combinition') == StockOrder::RIGHT_EYE) {
            $rules = [
                'patient'       =>  ['required', 'max:191'],
                'r_material'    =>  ['required', 'max:191'],
                'r_colour'      =>  ['required', 'max:191'],
                'r_coating'     =>  ['required', 'max:191'],
                'r_sph'         =>  ['required', 'max:191'],
                'r_cyl'         =>  ['required', 'max:191'],
                // 'r_size'        =>  ['required', 'max:191'],
                'r_quantity'    =>  ['required', 'max:191'],
                // 'r_price'       =>  ['required', 'max:191'],
            ];
            return $rules;
        } else {
            $rules = [
                'patient'       =>  ['required', 'max:191'],
                'l_material'    =>  ['required', 'max:191'],
                'l_colour'      =>  ['required', 'max:191'],
                'l_coating'     =>  ['required', 'max:191'],
                'l_sph'         =>  ['required', 'max:191'],
                'l_cyl'         =>  ['required', 'max:191'],
                // 'l_size'        =>  ['required', 'max:191'],
                'l_quantity'    =>  ['required', 'max:191'],
                // 'l_price'       =>  ['required', 'max:191'],
                'r_material'    =>  ['required', 'max:191'],
                'r_colour'      =>  ['required', 'max:191'],
                'r_coating'     =>  ['required', 'max:191'],
                'r_sph'         =>  ['required', 'max:191'],
                'r_cyl'         =>  ['required', 'max:191'],
                // 'r_size'        =>  ['required', 'max:191'],
                'r_quantity'    =>  ['required', 'max:191'],
                // 'r_price'       =>  ['required', 'max:191'],
            ];
            return $rules;
        }
    }
}
