<?php

namespace App\Listeners\Backend\Auth;

use Illuminate\Support\Facades\Mail;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Mail\Backend\DefaultOrderStatusMail;
use App\Events\Backend\Auth\OrderStatusMail;
/**
 * Class OrderStatusMailListner.
 */
class OrderStatusMailListner implements ShouldQueue
{
    /**
     * @var App\Models\Backend\EmailTemplate $template
     */
    private $template;

    /**
     * @var @email
     */
    private $email;
    
    /**
     * @var $order_id
     */

    private $order;
    
    /**
     * @param $event
     */

    public function handle($event)
    {

        $this->template = $event->template;
        $this->email = $event->order->user->email;
        $this->order = $event->order;

        Mail::to($this->email)->send(new DefaultOrderStatusMail($this->template,$this->order));
    }
}
