<?php

namespace App\Listeners\Frontend\Auth;

use App\Models\Auth\User;
use App\Models\Backend\Order;
use Illuminate\Support\Facades\Mail;
use App\Mail\Frontend\CustomerInquiry;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Events\Frontend\Auth\CustomerInquiryLog;

class CustomerInquiryLogListner implements ShouldQueue
{ 
    /**
     * @var
     */
    protected $email;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\Frontend\Auth\CustomerInquiryLog  $event
     * @return void
     */
    public function handle(CustomerInquiryLog $event)
    {
        if (isset($event->logs->user_to)) {
            $this->email = $event->logs->userTo->email;

        } elseif (isset($event->logs->order_id)) {
            $this->email = Order::find($event->logs->order_id)->user->email;

        } else {
            throw new Exception("Error Processing Request", 1);
        }

        Mail::to($this->email)->send(new CustomerInquiry($event->logs));
    }
}