<?php

namespace App\Mail\Backend;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class DefaultOrderStatusMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var App\Models\Backend\EmailTemplate $template
     */
    public $template;


    /**
     * @var App\Models\Backend\EmailTemplate $template
     */
    public $order;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($template,$order)
    {
        $this->template = $template;
        $this->order = $order;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    private function getMessage($message) {
        $message = str_replace("<p>","",$this->template->description);
        $message = str_replace("</p>","",$message);
        $message = str_replace("{!firstName!}",$this->order->user->first_name,$message);
        $message = str_replace("{!lastName!}",$this->order->user->last_name,$message);
        $message = str_replace("{!order_id!}","Oredr # ".$this->order->id,$message);
        $message = str_replace("&nbsp;"," ",$message);

        return $message;
    }


    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $message = $this->getMessage($this->template->description);

        return $this->markdown('emails.default-order-status-mail')
            ->with([
                'template'  =>  $this->template,
                'message'   =>  $message,
                'order_id'  =>  $this->order->id,
                'to'        =>  auth()->user()->id
            ]);
    }
}
