<?php

namespace App\Mail\Frontend;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class CustomerReplyMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * The order instance.
     *
     * @var PhoneLogs
     */
    protected $reply;

    /**
     *
     * @var $message
     */
    protected $message;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($reply,$message)
    {
        $this->reply = $reply;
        $this->message = $message;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('emails.customer-reply-admin')
            ->with([
                'response' => $this->reply == 1 ? 'Approved' : 'Canceled',
                'message' => $this->message
            ]);
    }
}
