<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class NewUserMail extends Mailable
{
    use Queueable, SerializesModels;

    public $accountNumber;
    public $email;
    public $temporaryPassword;
    public $businessName;
    public $firstName;
    public $lastName;
    public $address1;
    public $address2;
    public $city;
    public $province;
    public $postalCode;
    public $country;
    public $phone;
    public $fax;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->accountNumber = $data['accountNumber'];
        $this->email = $data['email'];
        $this->temporaryPassword = $data['temporaryPassword'] ?? Str::random(8); // Generate a random 8-character password if not provided
        $this->businessName = $data['businessName'];
        $this->firstName = $data['firstName'];
        $this->lastName = $data['lastName'];
        $this->address1 = $data['address1'];
        $this->address2 = $data['address2'];
        $this->city = $data['city'];
        $this->province = $data['province'];
        $this->postalCode = $data['postalCode'];
        $this->country = $data['country'];
        $this->phone = $data['phone'];
        $this->fax = $data['fax'];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('emails.new-user')->subject('Welcome to Lens Shapers Online Ordering')
        ->cc('info@lens-shapers.com');
    }
}
