<?php

namespace App\Models\Backend;

use Illuminate\Database\Eloquent\Model;
use App\Models\Backend\ImportedConsumablesOrder;

class ConsumablesOrder extends Model
{
    public $timestamps = false;

    protected $table = "consumable_orders";

    protected $fillable = [
        'id',
        'order_id',
        'name',
        'sub_name',
        'description',
        'quantity',
        'image',
        'image_hover',
        'price',
        'upc'
    ];

    /**
     * Create new order entry
     * @param  \Illuminate\Support\Collection   $order
     * @param  \Illuminate\Support\Collection   $model
     * @param  \Illuminate\Http\Request         $request
     * 
     * @return \Illuminate\Http\Response
     */
    public static function store($order,$model, $request) {
        return parent::create([
            'order_id'      => $order->id,
            'name'          => $model->name,
            'sub_name'      => $model->sub_name,
            'description'   => $model->description,
            'image'         => $model->image,
            'image_hover'   => $model->image_hover,
            'quantity'      => $request["quantity"],
        ]);
    }

    public static function getFilePath($file){
        if(file_exists(storage_path('app/public/'.$file)))
            return url('storage/app/public/'.$file);

        return false;
    }

    public static function getAllImages(){
        $response = [];
        $files = \Storage::disk('public')->allFiles('imports/images');
        foreach ($files as $key => $value) {
            $path = storage_path('app/public/'.$value);
            if(file_exists($path)){
                $response[] = [
                    'name'  =>  basename($value),
                    'size'  =>  \File::size($path),
                    'path'  =>  self::getFilePath($value)
                ];
            }
        }
        return $response;
    }

    public function getUpc(){
        $upc = $this->upc;
        if(empty($upc)){
            $cData = $this->getOriginalData(); 
            $upc = !empty($cData) ? $cData->upc : '';
        }
        return $upc;
    }

    public function getOriginalData(){
        return ImportedConsumablesOrder::where('name',$this->name)->first();
    }
}
