<?php

namespace App\Models\Backend;

use Validator;
use Illuminate\Http\Request;
use App\Custom\DropboxComponent;
use Illuminate\Support\Facades\File;

class CreditMemos
{
    const FILE_PATH_CSV = 'imports/lscreditmemos.csv';
    const FILE_PATH_JSON = 'imports/creditjustification.json';
    /**
     * @param $query
     * @param $uuid
     *
     * @return mixed
     */
    public static function import()
    {
        $filename = public_path(self::FILE_PATH_CSV);
        $handle = @fopen($filename, "r");
        $jsonData = [];
        if ($handle) {
            while (($row = fgetcsv($handle, 4096)) !== false) {
                if (empty($fields)) {
                    $fields = $row;
                    continue;
                }
                if(!isset($row[5])){
                    continue;
                }
                $request = new Request([
                    'ac_code'               =>  ltrim($row[5], "0"),//OECREJUS_CUST
                    'credit_number'         => $row[0],
                    'date'                  =>  date('Y-m-d',strtotime($row[1])),//OECREJUS_DATE
                    'reason'                =>  $row[2],//OECREJUS_DATE
                    'patient_reference'     =>  $row[3],//OECREJUS_DATE
                    'doc_no'                =>  $row[6],//OECREJUS_DOC_NO
                    'credit_amount'         =>  $row[4],//OECREJUS_CREDIT_AMT
                ]);
                if (self::csValidation($request)->fails() == false) {
                    if(!isset($jsonData[$request->get('ac_code')])){
                        $jsonData[$request->get('ac_code')] = [];
                    }
                    // $fileName = md5($request->get('doc_no') . microtime()).'.pdf';
                    // $contents = DropboxComponent::syncDrpboxFiles('/invoice pdfs',$request->get('doc_no').'.pdf',false);
                    // file_put_contents(storage_path('app/public/credit-memos/') . $fileName, $contents);
                    // $filePath = storage_path('app/public/credit-memos/'.$fileName);
                    $jsonData[$request->get('ac_code')][] = [
                        'date'  =>  $request->get('date'),
                        'reason'  =>  $request->get('reason'),
                        'doc_no'  =>  $request->get('doc_no'),
                        'credit_number'  =>  $request->get('credit_number'),
                        // 'doc_file'  =>  $fileName,
                        'patient_reference'  =>  $request->get('patient_reference'),
                        'credit_amount'  =>  $request->get('credit_amount')
                    ];
                    \Storage::disk('local')->put('public/'.self::FILE_PATH_JSON, json_encode($jsonData));
                }
                unset($row);
            }
            if (!feof($handle)) {
                echo "Error: unexpected fgets() failn";
            }
            fclose($handle);
        }
    }
    
    /**
     * Get the validation rules that apply to the request.
     * @param  $request
     *
     * @return boolean
     */
    public static function csValidation($request) {

        return Validator::make($request->toArray(), [
            'ac_code'       => "required|exists:users,ac_code",
            'date'          => "required|date",
            'doc_no'          => "required",
            // 'doc_credited'          => "required",
            'credit_amount'         =>  'required'
        ]);
    }

    public static function getData(){
        $response = [];
        $path = storage_path('app/public/'.self::FILE_PATH_JSON);
        if (File::exists($path)) {
            $data = json_decode(file_get_contents($path), true);
            $user = auth()->user();
            if(isset($data[$user->ac_code])){
                $response = $data[$user->ac_code];
            }
        }
        // echo "<pre>";
        // print_r($response);exit; 
        return $response;
    }

    public static function getFile($file){
        $contents = DropboxComponent::syncDrpboxFiles('/invoice pdfs',$file.'.pdf',false);
        file_put_contents(storage_path('app/public/credit-memos/') . $file.'.pdf', $contents);
        // return url('storage/app/public/credit-memos/' . $file.'.pdf');
        return route('frontend.files.credit-memos',custom_encode_hashids($file,'credit-memos'));
        // return chunk_split(base64_encode($contents));
    }
}
