<?php

namespace App\Models\Backend;

use App\Models\Auth\User;
use Illuminate\Database\Eloquent\Model;

class CustomerLinkStaff extends Model
{
    public $timestamps = false;

    protected $table = "customer_link_staff";

    protected $fillable = [
        'user_id',
        'customer_id',
    ];

    /**
     * @return mixed
     */
    public function customerStaff()
    {
        return $this->hasOne(User::class,'id','user_id');
    }

    /**
     * @return mixed
     */
    public function customerAdmin()
    {
        return $this->hasOne(User::class,'id','customer_id');
    }
}
