<?php

namespace App\Models\Backend;


use Illuminate\Http\Request;
use App\Models\Auth\User;
use Illuminate\Database\Eloquent\Model;
use App\Models\Backend\FrameStyles;
use GuzzleHttp\Client;

class FrameBrands extends Model
{ 
    protected $table = "frame_brands";
    protected $fillable = [
        'id',
        'manufacturer_id',
        'brand_id',
        'brand_name',
        'market',
        'status',
        'created_at',
        'updated_at'
    ];


    public function frameStyles()
    {
        return $this->hasMany(FrameStyle::class, 'brand_id', 'brand_id');
    }
}