<?php

namespace App\Models\Backend;


use Illuminate\Http\Request;
use App\Models\Auth\User;
use Illuminate\Database\Eloquent\Model;
use App\Models\Backend\FrameStyles;
use App\Models\Backend\FramePackages;


class FrameStyles extends Model
{ 
    protected $table = "frame_styles";

    protected $fillable = [
        'id',
        'model_id',
        'manufacturer_id',
        'brand_id',
        'collection_id',
        'configuration_fpc',
        'upc',
        'package_data',
        'color',
        'size',
        'status',
        'name',
        'tier',
        'price',
        'charge',
        'non_rx',
        'out_edge',
        'frame_style_data',
        'frame_lab_data',
        'A',
        'B',
        'ED',
        'DBL',
        'image',
        'created_at',
        'updated_at'

    ];

    public function frameManufacturer()
    {
        return $this->belongsTo(FrameManufacturer::class, 'manufacturer_id', 'manufacturer_id');
    }

    public function frameBrand()
    {
        return $this->belongsTo(FrameManufacturer::class, 'brand_id', 'brand_id');
    }

    protected function brandName() { return $this->belongsTo(FrameBrands::class); } 
    protected function tierCollection() { return array_combine(range(1, 8), array_map(fn($i) => "Tier$i", range(1, 8))); }
    protected function chargeCollection() { return ['1' => 'Sports', '2' => 'Wrap', '3' => 'Specialty']; }
    protected function packageCollection() { return FramePackages::where('status', 1)->pluck('name', 'id')->toArray(); }
    protected function priceFilters() { return ['non-blank' => 'Non-Blank', 'blank' => 'Blank']; }
    protected function statusFilter() { return ['All' => 'All', 'A' => 'A', 'D' => 'D']; }

    public static function removeAssetsImage($fileName){
        if(file_exists(public_path('assets/img/models/'.$fileName))){
            unlink(public_path('assets/img/models/'.$fileName));
            return true;
        }
        return false;
    }

    public static function uploadAssetsImage($image){
        $response = [];
        $fileName = $image->getClientOriginalName();
        $destinationPath = public_path('assets/img/models/');
        if($image->move($destinationPath, $fileName)){
            $response[] = url('public/assets/img/models/'.$fileName);
        }
        return $response;
    }

    
    public static function getFilePath($file){
        if(file_exists(public_path('assets/img/models/'.$file)))
            return url('public/assets/img/models/'.$file);
        return false;
    }

    /*
        Function to get inhouse model images
    */
    public static function getModelImages(){
        $response = [];
        $mediaPath = public_path('assets/img/models/');
        $files = \File::allFiles($mediaPath);
        foreach ($files as $key => $value) {
            $file = pathinfo($value);
            $path = $file['dirname'].'/'.$file['basename'];
            if(file_exists($path)){
                $response[] = [
                    'name'  =>  $file['basename'],
                    'size'  =>  \File::size($path),
                    'path'  =>  self::getFilePath($file['basename'])
                ];
            }
        }
        return $response;
    }
}
