<?php

namespace App\Models\Backend;

use App\Models\Auth\User;
use Illuminate\Database\Eloquent\Model;


class LabOrders extends Model
{
    public function getUsersForSelect() { return User::getUserByRoleName(config('access.users.customer_admin'))->sortBy('ac_code'); }

    public function getOrderType(): array { return ['rx' => 'Rx Order', 'consumables' => 'Consumable Order', 'stock' => 'Stock Order']; }

    public function isEnable(): bool { return true; }
}
