<?php

namespace App\Models\Backend;

use Illuminate\Database\Eloquent\Model;
use App\Models\Auth\User;
use App\Models\Backend\FramePackages;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class RxValidations extends Model
{
    public $timestamps = false;

    protected $table = "rx_validations";

    protected $fillable = [
        'lens_type','lens_manufacturer','lens_name','sub_type','base_curve','lens_material','lens_filter','lens_filter_header','lens_filter_header_sort','lens_colour','coating_made','coating_name','coating_colour','material_code','lens_code','colour_code','vendor_code','coating_code','sphMin','sphMax','sphDef','cylMin','cylMax','cylDef','minComb','maxComb','extSphMin','extSphMax','extCylMin','extCylMax','axisMin','axisMax','axisDef','addMin','addMax','addDef','corridor','corridorSh','strength','dpdMin','dpdMax','dpdDef','npdMin','npdMax','npdDef','ipdMin','ipdMax','ipdDef','ocMin','ocMax','ocDef','shMin','shMax','shDef','bocMin','bocMax','bocDef','prism1Min','prism1Max','prism1Def','prism2Min','prism2Max','prism2Def','totalPrismMin','totalPrismMax','aMin','aMax','aDef','bMin','bMax','bDef','edMin','edMax','edDef','dblMin','dblMax','dblDef','MaxDia','pantoMin','pantoMax','pantoDef','wrapMin','wrapMax','wrapDef','vertexMin','vertexMax','vertexDef','stockCsvColourValue','sphExclude','sphNoCyl','addExclude','Price_500','Price_501','Price_600','Price_601','disc_5000','disc_5001','disc_5002','disc_5004','disc_5005','disc_5006','disc_5010','disc_5012','disc_5014','disc_374','disc_273','disc_488','disc_414','disc_8400','discounts','packages','packagesPrice'
        // 'data_values'
    ];

    /**
    * Function to import Rx Lens from csv using cron job.
    */
    public static function import() {
        // $dataColumnsArray = json_decode('["lensMade","lensName","lensType","lensSubType","lensMaterial","lensFilter","lensColour","lensBC","lensDiaStandard","lensDiaShort","lensDiaShortMinSph","lensDiaShortMaxCyl","coatingMade","coatingName","coatingColour","lensFilterHeader","lensFilterHeaderSort","stockCsvColourValue","sphMin","sphMax","sphDef","cylMin","cylMax","cylDef","maxComb","extSphMin","extSphMax","extCylMin","extCylMax","axisMin","axisMax","axisDef","addMin","addMax","addDef","corridor","corridorSh","strength","dpdMin","dpdMax","dpdDef","npdMin","npdMax","npdDef","ipdMin","ipdMax","ipdDef","ocMin","ocMax","ocDef","shMin","shMax","shDef","bocMin","bocMax","bocDef","prism1Min","prism1Max","prism1Def","prism2Min","prism2Max","prism2Def","totalPrismMin","totalPrismMax","aMin","aMax","aDef","bMin","bMax","bDef","edMin","edMax","edDef","dblMin","dblMax","dblDef","MaxDia","pantoMin","pantoMax","pantoDef","wrapMin","wrapMax","wrapDef","vertexMin","vertexMax","vertexDef","Price_500","Price_501","Price_600","Price_601","disc_5000","disc_5001","disc_5002","disc_5004","disc_5005","disc_5006","disc_5010","disc_5012","disc_5014","disc_374","disc_273","disc_488","disc_414","disc_8400"]');

        $filename = storage_path('app/public/imports/lens_data.csv');//public_path('imports/lens_data.csv');
        set_time_limit(0);
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '0');
        $row = 0;
        $handle = @fopen($filename, "r");
        $csvData = [];
        $first = true;
        if ($handle) {
            $fields = [];
            $dataColumnsArray = [
                'lensMade', 'lensName', 'lensType', 'lensSubType', 'lensMaterial', 'lensFilter', 'lensFilterHeader', 
                'lensFilterHeaderSort', 'lensColour', 'lensBC', 'lensDiaStandard', 'lensDiaShort', 'lensDiaShortMinSph',
                'lensDiaShortMaxCyl', 'coatingMade', 'coatingName', 'coatingColour', 'stockCsvColourValue', 
                'materialCode', 'lensCode', 'colourCode', 'vendorCode', 'coatingCode',
                'sphExclude','sphNoCyl','addExclude', 'sphMin', 'sphMax', 'sphDef', 'cylMin', 'cylMax', 'cylDef','minComb', 'maxComb', 'extSphMin', 'extSphMax', 
                'extCylMin', 'extCylMax', 'axisMin', 'axisMax', 'axisDef', 'addMin', 'addMax', 'addDef', 'corridor', 
                'corridorSh', 'strength', 'dpdMin', 'dpdMax', 'dpdDef', 'npdMin', 'npdMax', 'npdDef', 'ipdMin', 
                'ipdMax', 'ipdDef', 'ocMin', 'ocMax', 'ocDef', 'shMin', 'shMax', 'shDef', 'bocMin', 'bocMax', 
                'bocDef', 'prism1Min', 'prism1Max', 'prism1Def', 'prism2Min', 'prism2Max', 'prism2Def', 
                'totalPrismMin', 'totalPrismMax', 'aMin', 'aMax', 'aDef', 'bMin', 'bMax', 'bDef', 'edMin', 
                'edMax', 'edDef', 'dblMin', 'dblMax', 'dblDef', 'MaxDia', 'pantoMin', 'pantoMax', 'pantoDef', 
                'wrapMin', 'wrapMax', 'wrapDef', 'vertexMin', 'vertexMax', 'vertexDef', 'Price_500', 'Price_501', 
                'Price_600', 'Price_601','Packages','PackagesPrice'
            ];
            while (($row = fgetcsv($handle, 4096)) !== false) {
                if (empty($fields)) {
                    $fields = $row;
                    continue;
                }
                if(!empty($row)){
                    $colDataValues = [];
                    $discounts = []; // Collect discounts here.
                    foreach ($dataColumnsArray as $columnName) {
                        $index = array_search($columnName, $fields);
                        $colDataValues[$columnName] = ($index !== false && isset($row[$index])) ? $row[$index] : null;
                    } 
                    foreach ($fields as $index => $columnName) {
                        if (preg_match('/^disc_\d+$/', $columnName)) {
                            $discounts[$columnName] = filter_var($row[$index], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
                        }
                    }
                    // foreach ($data_values as $key => $value) {
                    //     \Illuminate\Support\Facades\Schema::table('rx_validations', function (\Illuminate\Database\Schema\Blueprint $table) use ($key) {
                    //         $table->dropColumn([$key]);
                    //     });
                    //     \Illuminate\Support\Facades\Schema::table('rx_validations', function (\Illuminate\Database\Schema\Blueprint $table) use ($key) {
                    //         $table->string($key,50)->nullable();
                    //     });
                    // }
                    $data = [
                        'lens_type' => self::parseValue($colDataValues['lensType']),
                        'lens_manufacturer' => self::parseValue($colDataValues['lensMade']),
                        'lens_name' => self::parseValue($colDataValues['lensName']),
                        'sub_type' => self::parseValue($colDataValues['lensSubType']),
                        'base_curve' => self::parseValue($colDataValues['lensBC']),
                        'lens_material' => self::parseValue($colDataValues['lensMaterial']),
                        'lens_filter' => self::parseValue($colDataValues['lensFilter']),
                        'lens_filter_header' => self::parseValue($colDataValues['lensFilterHeader']),
                        'lens_filter_header_sort' => !empty($colDataValues['lensFilterHeaderSort']) ? $colDataValues['lensFilterHeaderSort'] : 0,
                        'lens_colour' => self::parseValue($colDataValues['lensColour']),
                        'coating_made' => self::parseValue($colDataValues['coatingMade']),
                        'coating_name' => self::parseValue($colDataValues['coatingName']),
                        'coating_colour' => self::parseValue($colDataValues['coatingColour']),
                        'material_code' => $colDataValues['materialCode'],
                        'lens_code' => $colDataValues['lensCode'],
                        'colour_code' => $colDataValues['colourCode'],
                        'vendor_code' => $colDataValues['vendorCode'],
                        'coating_code' => $colDataValues['coatingCode'],
                        'packages' => $colDataValues['Packages'],
                        'packagesPrice' => $colDataValues['PackagesPrice'],
                        'discounts' => json_encode($discounts),
                    ];   
                    if (!empty($data['packages'])) {
                        $packages = explode('|', $data['packages']);
                        $uniquePackages = [];
                    
                        foreach ($packages as $value) {
                            $trimmedValue = trim($value);
                            $packageId = explode(':', $trimmedValue);
                            $packageIdKey = $packageId[0];
                            $packageName = $packageId[1] ?? null; // Handle case where name might be missing
                    
                            if (!in_array($packageIdKey, $uniquePackages)) {
                                $existingPackage = FramePackages::where('package_id', $packageIdKey)->first();
                    
                                if ($existingPackage) {
                                    // If package exists, update its status to 1
                                    $existingPackage->update(['status' => 1]);
                                } else {
                                    // Create new package if it doesn't exist
                                    FramePackages::create([
                                        'name' => $packageName,
                                        'package_id' => $packageIdKey,
                                        'status' => 1
                                    ]);
                                }
                    
                                $uniquePackages[] = $packageIdKey;
                            }
                        }
                    }                                
                    $data_values = [];
                    for ($i = 17; $i <= 116; $i++) {
                        // Skip indices 18-22 as they are already handled in explicit mapping above
                        if ($i >= 18 && $i <= 22) {
                            continue;
                        }
                        
                        if(isset($dataColumnsArray[$i])){
                            $columnName = $dataColumnsArray[$i];
                            $data[$columnName] = '';
            
                            if ($i == 17) {
                                $data[$columnName] = $colDataValues[$columnName];
                            } elseif (is_numeric($colDataValues[$columnName])) {
                                $data[$columnName] = filter_var($colDataValues[$columnName], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) != '' 
                                    ? filter_var($colDataValues[$columnName], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) 
                                    : null;
                            } elseif (!empty($colDataValues[$columnName])) {
                                $data[$columnName] = json_encode(explode('\\', $colDataValues[$columnName]));
                            }
            
                            if ($i >= 97) {
                                $data[$columnName] = filter_var($colDataValues[$columnName], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) != '' 
                                    ? filter_var($colDataValues[$columnName], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION) 
                                    : 0;
                            }
                        }
                    }
                    if($first){
                        $first = false;
                        RxValidations::truncate();
                        FramePackages::query()->update(['status' => 0]);
                        // FramePackages::truncate();
                    }
                    RxValidations::create($data);
                }
                unset($row);
            }
            if (!feof($handle)) {
                echo "Error: unexpected fgets() failn";
            }
        }
        fclose($handle);
        // Cache::forget('rx_validation');
        // Cache::flush();
        // Cache::tags([app()->environment() . '_rx_validation'])->flush();
        // Cache::tags([app()->environment() . '_rx_keys_validation'])->flush();
        $user = User::getUserByRole(config('access.users.admin_role'));
        $user->sendWebNotifications([
            'title' =>  'Rx data imported!',
            'body' =>  'Rx data imported!',
            'data'  =>  [
                'type'  =>  'csv_imported',
                'is_notify' =>  true
            ]
        ],'admin');
        return true;
    }

    public static function importJson() {
        $filename = storage_path('app/public/imports/lens_data.csv');//public_path('imports/lens_data.csv');
        set_time_limit(0);
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', '0');
        $row = 0;
        $handle = @fopen($filename, "r");
        $csvData = [];
        $first = true;
        $jsonData = [
            // 'lens_type' =>  [],
            // 'lens_manufacturer' =>  [],
            // 'lens_name' =>  [],
            // 'sub_type' =>  [],
            // 'base_curve' =>  [],
            // 'lens_material' =>  [],
            // 'lens_filter' =>  [],
            // 'lens_colour' =>  [],
            // 'coating_made' =>  [],
            // 'coating_name' =>  [],
            // 'coating_colour' =>  [],
            // 'data_values'   =>  []
        ];
        $mapData = [];
        $keyValues = [            
            'lens_type_label' =>  2,
            'lens_manufacturer_label' =>  0,
            'lens_name_label' =>  1,
            'sub_type_label' =>  3,
            'lens_material_label' =>  7,
            'lens_filter_label' =>  4,
            'lens_filter_label' =>  5,
            'lens_colour_label' =>  6,
            'coating_made_label' =>  12,
            'coating_name_label' =>  13,
            'coating_colour_label' =>  14,
        ];
        if ($handle) {
            while (($row = fgetcsv($handle, 4096)) !== false) {
                if (empty($fields)) {
                    $fields = $row;
                    continue;
                }
                $data_values = [];
                for ($i=15; $i <= 134; $i++) {
                    $data_values[$fields[$i]] = '';
                    if(is_numeric($row[$i])){
                        $data_values[$fields[$i]] = filter_var($row[$i], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
                    }
                    elseif(!empty($row[$i])){
                        $data_values[$fields[$i]] = explode('\\',$row[$i]);
                    }
                }
                // $temp = [];
                // foreach ($keyValues as $key => $value) {
                //     $index = array_search($row[$value], $mapData);
                //     if($index === false){
                //         $mapData[] = $row[$value];
                //         $index = count($mapData) - 1;
                //     }
                //     $temp[$key] = $index;
                // }
                // $temp['data_values'] = $data_values;
                $jsonData[] = $data_values;
                if($first){
                    $first = false;
                }
                unset($row);
            }
            if (!feof($handle)) {
                echo "Error: unexpected fgets() failn";
            }
        }
        \Storage::disk('local')->put('public/imports/rx-lens-data.json', json_encode($jsonData));
        fclose($handle);
        Cache::flush();
        $user = User::getUserByRole(config('access.users.admin_role'));
        $user->sendWebNotifications([
            'title' =>  'Rx data imported!',
            'body' =>  'Rx data imported!',
            'data'  =>  [
                'type'  =>  'csv_imported',
                'is_notify' =>  true
            ]
        ],'admin');
        return true;
    }

    public static function parseValue($value)
    {
        $value = str_replace('\\', '\\\\', $value);
        $value = htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
        // $value = strtolower($value);
        $value = str_replace('.', '_point_', $value);
        $value = str_replace(' ', '_', $value);
        $value = str_replace('+', 'plus', $value);
        $value = str_replace('-', 'minus', $value);
        $value = str_replace("'", 'inverted', $value);

        return $value;
    }


    public static function decodeValue($value)
    {
        $value = str_replace('_s_',' ', $value);
        $value = str_replace('_point_', '.', $value);
        $value = str_replace('_',' ', $value);
        $value = str_replace('plus','+', $value);
        $value = str_replace('minus','-', $value);
        $value = str_replace('inverted',"'", $value);
        $value = str_replace('_',' ', $value);
        $value = str_replace('_bsl_','\\', $value);

        return ucwords($value);
    }

    public static function parseColumnName($name){
        $parser = [
            'lensType'      =>  'lens_type',
            'lensMade'      =>  'lens_manufacturer',
            'lensName'      =>  'lens_name_type',
            'lensBC'        =>  'base_curve',
            'lensMaterial'  =>  'lens_material',
            'lesnFilter'    =>  'lens_filter',
            'lensColour'    =>  'lens_colour',
            'coatingMade'   =>  'coating_made',
            'coatingName'   =>  'coating_name',
            'coatingColour'   =>  'coating_colour'
        ];

        if(isset($parser[$name]))
            return $parser[$name];

        return $name;
    }

    public static function getDataValuesAttributes(){
        return ['sphMin','sphMax','sphDef','cylMin','cylMax','cylDef','minComb','maxComb','extSphMin','extSphMax','extCylMin','extCylMax','axisMin','axisMax','axisDef','addMin','addMax','addDef','corridor','corridorSh','strength','dpdMin','dpdMax','dpdDef','npdMin','npdMax','npdDef','ipdMin','ipdMax','ipdDef','ocMin','ocMax','ocDef','shMin','shMax','shDef','bocMin','bocMax','bocDef','prism1Min','prism1Max','prism1Def','prism2Min','prism2Max','prism2Def','totalPrismMin','totalPrismMax','aMin','aMax','aDef','bMin','bMax','bDef','edMin','edMax','edDef','dblMin','dblMax','dblDef','MaxDia','pantoMin','pantoMax','pantoDef','wrapMin','wrapMax','wrapDef','vertexMin','vertexMax','vertexDef','stockCsvColourValue','sphExclude','sphNoCyl','addExclude','Price_500','Price_501','Price_600','Price_601','discounts'];
    }

    public static function validateData($request){
        $post = $request;
        $user = auth()->user();
        $profile = $user->getCustomerAdmin()->profile;
        $priceId = 0;
        $discount = 0;
        if(!empty($profile)){
            $priceId = $profile->cust_prlist_default;
            $discount = $profile->cust_vsp_office_code;
        }        
        unset($post['_token']);
        
        $post['discount'] = $discount;
        $post['priceId'] = $priceId;

        // Simple, consistent cache key approach
        $cacheIndexKey = 'rx_validation_' . hash('crc32', json_encode($post));
        $cacheTag = app()->environment() . '_rx_validation';
        $cacheTTL = now()->addMonths(12);

        // Try to get from cache first
        if (Cache::has($cacheTag . '_' . $cacheIndexKey)) {
            return Cache::get($cacheTag . '_' . $cacheIndexKey);
        }

        $post['discount'] = $discount;
        $post['priceId'] = $priceId;

        $response = [];
        $selected = $request['selected_index'];
        $model = self::select('*');
        // Apply conditionally if 'lens_type' is not empty
        if (!empty($request['lens_type'])) {
            $model->where('lens_type', $request['lens_type']);
        }
        // Apply conditionally if 'sub_type' is not empty
        if (!empty($request['sub_type'])) {
            $searchTerm = $request['sub_type'];
            $model->where('sub_type', 'LIKE', "%$searchTerm%");
        }
        // Apply conditionally if 'lens_name' is not empty
        if (!empty($request['lens_name'])) {
            $model->where('lens_name', $request['lens_name']);
        }
        // Apply conditionally if 'lens_material' is not empty
        if (!empty($request['lens_material'])) {
            $model->where('lens_material', $request['lens_material']);
        }
        // Apply conditionally if 'lens_filter' is not empty
        if (!empty($request['lens_filter'])) {
            $model->where('lens_filter', $request['lens_filter']);
        }
        // Apply conditionally if 'lens_colour' is not empty
        if (!empty($request['lens_colour'])) {
            $model->where('lens_colour','Like', '%'.$request['lens_colour'].'%');
        }
        // Apply conditionally if 'coating_name' is not empty
        if (!empty($request['coating_name'])) {
            $model->where('coating_name', $request['coating_name']);
        }
        // Apply conditionally if 'coating_colour' is not empty
        if (!empty($request['coating_colour'])) {
            $model->where('coating_colour','Like', '%'.$request['coating_colour'].'%');
        }
        $model = $model->limit(2000)->get();
        if(count($model) <= 0 && isset($request['id'])){
            $model = self::select('*')->where('id',$request['id'])->get();
        }

        // $response = [
        //     'lens_type' => [],
        //     'lens_manufacturer' => [],
        //     'lens_name' => [],
        //     'sub_type' => [],
        //     'lens_colour' => [],
        //     'lens_material' => [],
        //     'lens_filter' => [],
        //     'coating_made' => [],
        //     'coating_name' => [],
        //     'coating_colour' => [],
        //     'data_values'   =>  []
        // ];
        $response = [];
        $response['data_values']['price'] = 0;
        $response['data_values']['discount'] = 0;
        $response['data_values']['packages'] = [];
        $list = [];
        // $response['data_values']['brand'] = [];
        foreach ($model as $key => $value) {
            foreach (self::getDataValuesAttributes() as $key2 => $index) {
                $keyValue = $value->$index;
                if(!isset($response['data_values'][$index]))
                    $response['data_values'][$index] = 0;

                if(strpos($index, 'Min') !== false && $response['data_values'][$index] > $keyValue)
                    $response['data_values'][$index] = (FLOAT) $keyValue;
                elseif(strpos($index, 'Max') !== false && $response['data_values'][$index] < $keyValue)
                    $response['data_values'][$index] = (FLOAT) $keyValue;
                elseif($response['data_values'][$index] === 0 && !empty($keyValue) && ($index == 'strength' || $index == 'corridor' || $index == 'corridorSh')){
                    $response['data_values'][$index] = json_decode($keyValue);
                }
                elseif($response['data_values'][$index] === 0){
                    $response['data_values'][$index] = !is_numeric($keyValue) ? $keyValue : (float) $keyValue;
                }

                $priceKey = 'Price_'.$priceId;
                if(strpos($index, 'Price') !== false){
                    if(strtolower($index) == strtolower($priceKey)){
                        if($response['data_values']['price'] > $keyValue || $response['data_values']['price'] == '')
                        $response['data_values']['price'] = (FLOAT) $keyValue;
                    }

                    unset($response['data_values'][$index]);
                }

                $priceKey = 'disc_'.$discount;
                if($index == 'discounts'){
                    $discounts = json_decode($keyValue,1);
                    if(isset($discounts[strtolower($priceKey)])){
                        if($response['data_values']['discount'] > $discounts[strtolower($priceKey)] || $response['data_values']['discount'] == '')
                        $response['data_values']['discount'] = (FLOAT) $discounts[strtolower($priceKey)];
                    }

                    unset($response['data_values'][$index]);
                }
            }
            if (!empty($value->packages)) {
                $packages = explode('|', $value->packages);
                $packagesPrice = explode('|', $value->packagesPrice);
                $selectedPackage = isset($request['packages']) ? $request['packages'] : ''; // Get the requested package

                foreach ($packages as $key5 => $package) {
                    $packageParts = explode(':', $package);
                    if (count($packageParts) == 2) {
                        $packageKey = trim($packageParts[0]); // Extract package key (e.g., "Safety" or "Snooker")
                        $packageName = trim($packageParts[1]); // Extract package name (e.g., "Safety Package" or "Snooker Glasses")
                        $prices = isset($packagesPrice[$key5]) ? explode('\\', $packagesPrice[$key5]) : []; // Split prices by '\'

                        if ($selectedPackage) {
                            // If a specific package is requested, return only that package
                            if ($packageName == $selectedPackage) {
                                $list[] = [
                                    'name'  => $packageName,
                                    'price' => $prices,
                                    'prices' => $packagesPrice,
                                    'id' => $value->id,
                                ];
                                break; // Stop after finding the package
                            }
                        } else {
                            // If no package is specified, return all
                            $list[] = [
                                'name'  => $packageName,
                                'price' => $prices,
                                    'prices' => $packagesPrice,
                                    'id' => $value->id,
                            ];
                        }
                    }
                }

                $response['data_values']['packages'] = $list;
            }
        }

        // if(!empty($request['packages'])){
        //     $package = DB::table('frame_packages')
        //         ->where('name',$request['packages'])
        //         ->first();
        //     if(!empty($package)){
        //         $styles = DB::table('frame_styles')
        //         ->whereNotNull('package_data')
        //         ->where('package_data','!=','')->get();
        //         $brandNames = [];

        //         foreach ($styles as $key => $value) {
        //             $packageData = json_decode($value->package_data, true);
        //             if (!empty($packageData) && array_key_exists($package->id, $packageData)) {
        //                 $json = json_decode($value->frame_style_data, true);
        //                 if (!empty($json) && isset($json['BrandName'])) {
        //                     $brandNames[] = $json['BrandName'];
        //                 }
        //             }
        //         }

        //         // Ensure uniqueness
        //         $response['data_values']['brand'] = array_values(array_unique($brandNames));
        //     }
        // }else{
        //     $response['data_values']['brand'] = DB::table('frame_brands')->orderBy('brand_name','asc')->pluck('brand_name')->toArray();
        // }

        // Store in cache with consistent TTL
        Cache::put($cacheTag . '_' . $cacheIndexKey, $response, $cacheTTL);

        return $response;
    }

    /**
     * Clear all RX validation cache
     */
    public static function clearRxValidationCache()
    {
        $cacheTag = app()->environment() . '_rx_validation';
        // Cache::tags([$cacheTag])->flush();
    }

    /**
     * Clear specific RX validation cache by price ID
     */
    public static function clearRxValidationCacheByPriceId($priceId)
    {
        $cacheTag = app()->environment() . '_rx_validation';
        $pattern = 'rx_validation_' . '_*';
        
        // Note: This is a simplified approach. For production, consider using Redis SCAN
        Cache::tags([$cacheTag])->flush();
    }

    public static function validateJsonData($request){

        if(empty(Cache::get('rx-lens-data'))){
            ini_set('memory_limit', -1);
            $path = storage_path('app/public/imports/rx-lens-data.json');
            $data = json_decode(file_get_contents($path), true);
            Cache::put('rx-lens-data',  $data  , now()->addMinutes(2880));
        }
        echo "<pre>";
        print_r($data);exit;
        $rxLensJsonData = Cache::get('1rx-lens-data');
        $post = $request;
        unset($post['_token']);
        $cacheIndexKey = '';
        foreach ($post as $key => $value) {
            if(!empty($value))
                $cacheIndexKey .= '_'.$value;
        }
        if(empty($cacheIndexKey))
            $cacheIndexKey = 'rx_default';

        // if(!empty(Cache::get($cacheIndexKey)))
        //     return Cache::get($cacheIndexKey);

        $user = auth()->user();
        $priceId = $user->profile->cust_prlist_default;
        $response = [];
        $selected = $request['selected_index'];

        $model = self::select('lens_type','lens_manufacturer','lens_name','sub_type','base_curve','lens_material','lens_filter','lens_colour','coating_made','coating_name','coating_colour','data_values');

        if(!empty($request['lens_type']))
            $model = $model->where('lens_type',$request['lens_type']);
        if($selected != 'lens_type' && !empty($request['sub_type']))
            $model = $model->where('sub_type','LIKE','%'.$request['sub_type'].'%');
        // if($selected != 'sub_type' && !empty($request['lens_manufacturer']))
        //     $model = $model->where('lens_manufacturer',$request['lens_manufacturer']);
        if($selected != 'lens_manufacturer' && !empty($request['lens_name']))
            $model = $model->where('lens_name',$request['lens_name']);
        if($selected != 'lens_name' && !empty($request['base_curve']))
            $model = $model->where('base_curve','LIKE','%'.$request['base_curve'].'%');
        if($selected != 'base_curve' && !empty($request['lens_material']))
            $model = $model->where('lens_material',$request['lens_material']);
        if($selected != 'lens_material' && !empty($request['lens_filter']))
            $model = $model->where('lens_filter',$request['lens_filter']);
        if($selected != 'lens_filter' && !empty($request['lens_colour']))
            $model = $model->where('lens_colour','LIKE','%'.$request['lens_colour'].'%');
        if($selected != 'lens_colour' && !empty($request['coating_made']))
            $model = $model->where('coating_made',$request['coating_made']);
        if($selected != 'coating_made' && !empty($request['coating_name']))
            $model = $model->where('coating_name',$request['coating_name']);
        if($selected != 'coating_name' && !empty($request['coating_colour']))
            $model = $model->where('coating_colour','LIKE','%'.$request['coating_colour'].'%');

        $model = $model->distinct()->get();

        $response = [
            'lens_type' => [],
            'lens_manufacturer' => [],
            'lens_name' => [],
            'sub_type' => [],
            'lens_colour' => [],
            'lens_material' => [],
            'lens_filter' => [],
            'coating_made' => [],
            'coating_name' => [],
            'coating_colour' => [],
            'data_values'   =>  []
        ];
        $response['data_values']['price'] = '';
        foreach ($model as $key => $value) {

            if(!empty($value->lens_type))
                $response['lens_type'][$value->lens_type] = self::decodeValue($value->lens_type);
            // if(!empty($value->lens_manufacturer))
                // $response['lens_manufacturer'][$value->lens_manufacturer] = self::decodeValue($value->lens_manufacturer);
            if(!empty($value->lens_name)){
                if(!isset($response['lens_name'][$value->lens_manufacturer]))
                    $response['lens_name'][$value->lens_manufacturer] = [];

                $lensName = self::decodeValue($value->lens_name);

                $response['lens_name'][$value->lens_manufacturer][$value->lens_name] = $lensName;
            }
            if(!empty($value->sub_type)){
                foreach (explode('\\', $value->sub_type) as $key2 => $value2) {
                    if(!empty($value2))
                        $response['sub_type'][$value2] = self::decodeValue($value2);
                }
            }

            $response['right_base_curve'][0] = '';
            foreach (explode('\\', $value->base_curve) as $key2 => $value2) {
                if(!empty($value2))
                    $response['right_base_curve'][$value2] = $value2;
            }
            foreach (explode('\\', $value->lens_colour) as $key2 => $value2) {
                if(!empty($value2))
                    $response['lens_colour'][$value2] = self::decodeValue($value2);
            }

            if(!empty($value->lens_material))
                $response['lens_material'][$value->lens_material] = self::decodeValue($value->lens_material);
            if(!empty($value->lens_filter))
                $response['lens_filter'][$value->lens_filter] = self::decodeValue($value->lens_filter);
            // if(!empty($value->coating_made))
            //     $response['coating_made'][$value->coating_made] = self::decodeValue($value->coating_made);

            if(!empty($value->coating_name)){
                if(!isset($response['coating_name'][$value->coating_made]))
                    $response['coating_name'][$value->coating_made] = [];

                $lensName = self::decodeValue($value->coating_name);

                $response['coating_name'][$value->coating_made][$value->coating_name] = $lensName;
            }
            if(!empty($value->coating_colour)){
                foreach (explode('\\', $value->coating_colour) as $key2 => $value2) {
                    if(!empty($value2))
                        $response['coating_colour'][$value2] = self::decodeValue($value2);
                }
            }
            $dataValues = json_decode($value->data_values,true);
            if(!empty($dataValues)){
                foreach ($dataValues as $key => $value) {

                    if(!isset($response['data_values'][$key]))
                        $response['data_values'][$key] = 0;

                    if(strpos($key, 'Min') !== false && $response['data_values'][$key] > $value)
                        $response['data_values'][$key] = (FLOAT) $value;
                    elseif(strpos($key, 'Max') !== false && $response['data_values'][$key] < $value)
                        $response['data_values'][$key] = (FLOAT) $value;
                    elseif($response['data_values'][$key] === 0){
                        $response['data_values'][$key] = !is_numeric($value) ? $value : (float) $value;
                    }

                    $priceKey = 'Price_'.$priceId;
                    if(strpos($key, 'Price') !== false){
                        if(strtolower($key) == strtolower($priceKey)){
                            if($response['data_values']['price'] > $value || $response['data_values']['price'] == '')
                            $response['data_values']['price'] = (FLOAT) $value;
                        }

                        unset($response['data_values'][$key]);
                    }
                }
            }
        }
        // Cache::put($cacheIndexKey,  $response  , now()->addMinutes(2880));
        return $response;
    }

    /**
    * Function to import Rx Lens from csv using cron job.
    */
    public static function importRxAddons() {
        $filename = storage_path('app/public/imports/rx_lens_addons.csv');
        $row = 0;
        $handle = @fopen($filename, "r");
        $jsonData = [
            'item_category'  =>  []
        ];
        if ($handle) {
            while (($row = fgetcsv($handle, 4096)) !== false) {
                if (empty($fields)) {
                    $fields = $row;
                    continue;
                }
                $item_category_key = self::parseColumnValue($row[0]);
                if(!isset($jsonData['item_category'][$item_category_key])){
                    $jsonData['item_category'][$item_category_key] = [
                        'label' => '',
                        'price_500' =>  0.00,
                        'price_501' =>  0.00,
                        'price_600' =>  0.00,
                        'price_601' =>  0.00,
                        'item_type' =>  []
                    ];
                }
                $jsonData['item_category'][$item_category_key]['label'] = $row[0];
                $jsonData['item_category'][$item_category_key]['price_500'] = $row[5];
                $jsonData['item_category'][$item_category_key]['price_501'] = $row[6];
                $jsonData['item_category'][$item_category_key]['price_600'] = $row[7];
                $jsonData['item_category'][$item_category_key]['price_601'] = $row[8];
                //Item Type
                $item_type_key = self::parseColumnValue($row[1]);
                if(!isset($jsonData['item_category'][$item_category_key]['item_type'][$item_type_key])){
                    $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key] = [
                        'label' => '',
                        'price_500' =>  0.00,
                        'price_501' =>  0.00,
                        'price_600' =>  0.00,
                        'price_601' =>  0.00,
                        'item_sub_type' =>  []
                    ];
                }
                $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['label'] = $row[1];
                 $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['price_500'] = $row[5];
                 $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['price_501'] = $row[6];
                 $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['price_600'] = $row[7];
                 $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['price_601'] = $row[8];
                //Item Sub type
                $explode = explode('\\', $row[2]);
                foreach ($explode as $key => $value) {
                    $item_sub_type = self::parseColumnValue($value);
                    if(!isset($jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['item_sub_type'][$item_sub_type])){
                        $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['item_sub_type'][$item_sub_type] = [
                            'label' => '',
                            'price_500' =>  0.00,
                            'price_501' =>  0.00,
                            'price_600' =>  0.00,
                            'price_601' =>  0.00,
                            'item_colour' =>  []
                        ];
                    }
                    $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['item_sub_type'][$item_sub_type]['label'] = $value;
                    $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['item_sub_type'][$item_sub_type]['price_500'] = $row[5];
                     $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['item_sub_type'][$item_sub_type]['price_501'] = $row[6];
                     $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['item_sub_type'][$item_sub_type]['price_600'] = $row[7];
                     $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['item_sub_type'][$item_sub_type]['price_601'] = $row[8];
                }
                //Item Colour
                $splitColours = explode('\\', $row[3]); // Item Colour
                $splitSubColours = explode('\\', $row[4]); // Item Sub Colour

                foreach ($splitColours as $colour) {
                    $item_colour_key = self::parseColumnValue($colour);

                    if (!isset($jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['item_sub_type'][$item_sub_type]['item_colour'][$item_colour_key])) {
                        $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['item_sub_type'][$item_sub_type]['item_colour'][$item_colour_key] = [
                            'label' => $colour,
                            'price_500' => $row[5],
                            'price_501' => $row[6],
                            'price_600' => $row[7],
                            'price_601' => $row[8],
                            'item_sub_colour' => []
                        ];
                    }

                    foreach ($splitSubColours as $subColour) {
                        $item_sub_colour_key = self::parseColumnValue($subColour);
                        if (!isset($jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['item_sub_type'][$item_sub_type]['item_colour'][$item_colour_key]['item_sub_colour'][$item_sub_colour_key])) {
                            $jsonData['item_category'][$item_category_key]['item_type'][$item_type_key]['item_sub_type'][$item_sub_type]['item_colour'][$item_colour_key]['item_sub_colour'][$item_sub_colour_key] = [
                                'label' => $subColour,
                                'price_500' => $row[5],
                                'price_501' => $row[6],
                                'price_600' => $row[7],
                                'price_601' => $row[8],
                            ];
                        }
                    }
                }
                unset($row);
            }
            if (!feof($handle)) {
                echo "Error: unexpected fgets() failn";
            }
        }
        fclose($handle);
        \Storage::disk('local')->put('public/imports/rx_lens_addons.json', json_encode($jsonData));
        return true;
    }

    public static function importRxAdditionalCharges() {
        $filename = storage_path('app/public/imports/rx_additional_charges.csv');
        $row = 0;
        $handle = @fopen($filename, "r");
        if ($handle) {
            while (($row = fgetcsv($handle, 4096)) !== false) {
                if (empty($fields)) {
                    $fields = $row;
                    continue;
                }
                $data = [];
                foreach ($fields as $key => $value) {
                    $data[$value] = $row[$key];
                }
                $jsonData[] = $data;
                unset($row);
            }
            if (!feof($handle)) {
                echo "Error: unexpected fgets() failn";
            }
        }
        fclose($handle);
        \Storage::disk('local')->put('public/imports/rx_additional_charges.json', json_encode($jsonData));
        return true;
    }

    public static function importRxBaseCurve() {
        $filename = storage_path('app/public/imports/base-curve-calculations.csv');
        $row = 0;
        $handle = @fopen($filename, "r");
        $data = [];
        if ($handle) {
            while (($row = fgetcsv($handle, 4096)) !== false) {
                if (empty($fields)) {
                    $fields = $row;
                    continue;
                }
                foreach ($fields as $key => $value) {
                    if(!isset($data[self::baseCurveparseColumnValue($value)])){
                        $data[self::baseCurveparseColumnValue($value)] = [];
                    }
                    $data[self::baseCurveparseColumnValue($value)][] = $row[$key];
                }
                unset($row);
            }
            if (!feof($handle)) {
                echo "Error: unexpected fgets() failn";
            }
        }
        fclose($handle);
        \Storage::disk('local')->put('public/imports/base-curve-calculations.json', json_encode($data));
        return true;
    }

    public static function filterFrameInfo($type, $brand = '', $model = '', $colour = '', $size = '', $package = '', $isOnlyPrice = false, $statusD = false)
    {
        // Simple, consistent cache key approach
        $params = compact('type', 'brand', 'model', 'colour', 'size', 'package', 'isOnlyPrice', 'statusD');
        $cacheKey = 'frame_info_' . $type . '_' . hash('crc32', json_encode($params));
        $cacheTTL = now()->addMonths(12);

        $cacheKeyFull = app()->environment() . '_frame_info_' . $cacheKey;
        if (Cache::has($cacheKeyFull)) {
            return Cache::get($cacheKeyFull);
        }
        $result = (function () use ($type, $brand, $model, $colour, $size, $package, $isOnlyPrice, $statusD) {
            $response = [
                'list'  =>  [],
                'meta_data'  =>  []
            ];

            if ($type == 'brand' && !empty($brand)) {
                $brand = '';
            }

            $brandId = DB::table('frame_brands')->where('brand_name', $brand)->first();
            $styles = [];
            if (!empty($brandId)) {
                $styles = DB::table('frame_styles')->where('brand_id', $brandId->brand_id);
            } elseif (empty($brand)) {
                $styles = DB::table('frame_styles');
            }

            if (!empty($styles) && !empty($model)) {
                $styles = $styles->where('name', $model);
            }
            if (!empty($styles) && !empty($colour)) {
                $styles = $styles->where('color', $colour);
            }
            if (!empty($styles) && !empty($size)) {
                $styles = $styles->where('size', $size);
            }

            $col = $type;
            if ($type == 'colour') {
                $col = 'color';
            } elseif ($type == 'model') {
                $col = 'name';
            } elseif (empty($type)) {
                $col = 'size';
            }

            $packageObj = null;
            if (!empty($styles) && !empty($package)) {
                $styles = $styles->whereNotNull('package_data')->where('package_data', '!=', '');
                $packageObj = DB::table('frame_packages')->where('name', $package)->first();
            }
            if (!empty($styles) && $isOnlyPrice == 'true') {
                $styles = $styles->whereNotNull('price')->where('price', '!=', '');
            }
            // if (!empty($styles) && $statusD == 'true') {
            //     $styles = $styles->where('status', '!=', 'D');
            // }

            if (!empty($styles) && !empty($brandId)) {
                $styles = $styles->distinct($col)->orderBy($col, 'asc');
            } elseif ($col == 'brand' && empty($package)) {
                $brands = DB::table('frame_brands');
                if ($isOnlyPrice == 'true') {
                    $query = DB::table('frame_styles')->whereNotNull('price')->where('price', '!=', '');
                    $query = $query->distinct('brand_id')->pluck('brand_id')->toArray();
                    $brands = $brands->whereIn('brand_id', $query);
                }
                $response['list'] = $brands->orderBy('brand_name', 'asc')->pluck('brand_name')->toArray();
                return $response;
            }

            if (!empty($styles)) {
                $styles = $styles->get();
            }

            foreach ($styles as $key => $value) {
                $packageData = json_decode($value->package_data, true);
                if ($col == 'brand' &&
                    (
                        empty($package) ||
                        (!empty($packageData) && array_key_exists(optional($packageObj)->id, $packageData))
                    )
                ) {
                    $json = json_decode($value->frame_style_data, true);
                    if (!empty($json) && isset($json['BrandName'])) {
                        $response['list'][$json['BrandName']] = $json['BrandName'];
                    }
                } elseif (empty($package) || (!empty($packageObj) && array_key_exists($packageObj->id, $packageData))) {
                    $response['list'][$value->$col] = $value->$col;
                }
            }

            $response['list'] = array_values(array_unique($response['list']));

            if (!empty($colour) && count($response['list']) == 1) {
                $json = json_decode($styles[0]->frame_style_data, 1);
                if (!empty($json)) {
                    $response['meta_data']['data'] = $json;
                    $response['meta_data']['a'] = $json['A'];
                    $response['meta_data']['b'] = $json['B'];
                    $response['meta_data']['ed'] = $json['ED'];
                    $response['meta_data']['dbl'] = $json['DBL'];
                    $response['meta_data']['edge_type'] = isset($json['EdgeType']) ? strtolower($json['EdgeType']) : '';
                    $response['meta_data']['frame_type'] = isset($json['Material']) ? strtolower($json['Material']) : '';
                    $response['meta_data']['package_tier'] = (int) $value->tier;
                    $response['meta_data']['price'] = (float) $value->price;
                }
            }

            return $response;
        })();
        Cache::put($cacheKeyFull, $result, $cacheTTL);
        return $result;
    }

    /**
     * Clear all frame info cache
     */
    public static function clearFrameInfoCache()
    {
        $cacheTag = app()->environment() . '_frame_info';
        // Cache::tags([$cacheTag])->flush();
    }

    private static function parseColumnValue($value)
    {
        $value = strtolower($value);
        $value = str_replace('-', '_', $value);
        $value = str_replace(' ', '_s_', $value);
        $value = str_replace('+', '_plus_', $value);
        $value = str_replace('/', '_fsl_', $value);

        return $value;
    }

    private static function baseCurveparseColumnValue($value)
    {
        $value = str_replace('.', '_point_', $value);
        $value = str_replace(' ', '_', $value);
        $value = str_replace('+', 'plus', $value);

        return strtolower($value);
    }

    /**
     * Function to validate and get lens information based on RX lens codes
     */
    public static function validateRxLensCodes($materialCode, $lensCode, $colourCode, $vendorCode, $coatingCode)
    {
        $response = [
            'valid' => false,
            'lens_info' => null,
            'min_max_values' => null,
            'errors' => []
        ];

        try {
            // Build query based on the provided codes
            $query = self::select('*');

            if (!empty($materialCode)) {
                $query->where('material_code', $materialCode);
            }

            if (!empty($lensCode)) {
                // lensCode can contain multiple values separated by \
                $lensCodes = explode('\\', $lensCode);
                $query->where(function($q) use ($lensCodes) {
                    foreach ($lensCodes as $code) {
                        $q->orWhere('lens_code', 'LIKE', '%' . trim($code) . '%');
                    }
                });
            }

            if (!empty($colourCode)) {
                // colourCode can contain multiple values separated by \
                $colourCodes = explode('\\', $colourCode);
                $query->where(function($q) use ($colourCodes) {
                    foreach ($colourCodes as $code) {
                        $q->orWhere('colour_code', 'LIKE', '%' . trim($code) . '%');
                    }
                });
            }

            if (!empty($vendorCode)) {
                $query->where('vendor_code', $vendorCode);
            }

            if (!empty($coatingCode)) {
                $query->where('coating_code', $coatingCode);
            }

            $lensData = $query->get();

            if ($lensData->count() > 0) {
                $response['valid'] = true;
                $response['lens_info'] = $lensData->first();
                
                // Calculate min/max values from all matching records
                $response['min_max_values'] = self::calculateMinMaxValues($lensData);
            } else {
                $response['errors'][] = 'No matching lens found with the provided codes';
            }

        } catch (\Exception $e) {
            $response['errors'][] = 'Error validating lens codes: ' . $e->getMessage();
        }

        return $response;
    }

    /**
     * Calculate min/max values from lens data
     */
    private static function calculateMinMaxValues($lensData)
    {
        $minMax = [
            'sph' => ['min' => null, 'max' => null],
            'cyl' => ['min' => null, 'max' => null],
            'axis' => ['min' => null, 'max' => null],
            'add' => ['min' => null, 'max' => null],
            'pd' => ['min' => null, 'max' => null],
            'base_curve' => ['min' => null, 'max' => null],
            'prism' => ['min' => null, 'max' => null],
        ];

        foreach ($lensData as $lens) {
            // Sphere values
            if ($lens->sphMin !== null && ($minMax['sph']['min'] === null || $lens->sphMin < $minMax['sph']['min'])) {
                $minMax['sph']['min'] = $lens->sphMin;
            }
            if ($lens->sphMax !== null && ($minMax['sph']['max'] === null || $lens->sphMax > $minMax['sph']['max'])) {
                $minMax['sph']['max'] = $lens->sphMax;
            }

            // Cylinder values
            if ($lens->cylMin !== null && ($minMax['cyl']['min'] === null || $lens->cylMin < $minMax['cyl']['min'])) {
                $minMax['cyl']['min'] = $lens->cylMin;
            }
            if ($lens->cylMax !== null && ($minMax['cyl']['max'] === null || $lens->cylMax > $minMax['cyl']['max'])) {
                $minMax['cyl']['max'] = $lens->cylMax;
            }

            // Axis values
            if ($lens->axisMin !== null && ($minMax['axis']['min'] === null || $lens->axisMin < $minMax['axis']['min'])) {
                $minMax['axis']['min'] = $lens->axisMin;
            }
            if ($lens->axisMax !== null && ($minMax['axis']['max'] === null || $lens->axisMax > $minMax['axis']['max'])) {
                $minMax['axis']['max'] = $lens->axisMax;
            }

            // Add values
            if ($lens->addMin !== null && ($minMax['add']['min'] === null || $lens->addMin < $minMax['add']['min'])) {
                $minMax['add']['min'] = $lens->addMin;
            }
            if ($lens->addMax !== null && ($minMax['add']['max'] === null || $lens->addMax > $minMax['add']['max'])) {
                $minMax['add']['max'] = $lens->addMax;
            }

            // PD values
            if ($lens->dpdMin !== null && ($minMax['pd']['min'] === null || $lens->dpdMin < $minMax['pd']['min'])) {
                $minMax['pd']['min'] = $lens->dpdMin;
            }
            if ($lens->dpdMax !== null && ($minMax['pd']['max'] === null || $lens->dpdMax > $minMax['pd']['max'])) {
                $minMax['pd']['max'] = $lens->dpdMax;
            }

            // Base curve values
            if ($lens->base_curve !== null) {
                $baseCurves = is_string($lens->base_curve) ? json_decode($lens->base_curve, true) : [$lens->base_curve];
                if (is_array($baseCurves)) {
                    foreach ($baseCurves as $bc) {
                        if (is_numeric($bc)) {
                            if ($minMax['base_curve']['min'] === null || $bc < $minMax['base_curve']['min']) {
                                $minMax['base_curve']['min'] = $bc;
                            }
                            if ($minMax['base_curve']['max'] === null || $bc > $minMax['base_curve']['max']) {
                                $minMax['base_curve']['max'] = $bc;
                            }
                        }
                    }
                }
            }

            // Prism values
            if ($lens->prism1Min !== null && ($minMax['prism']['min'] === null || $lens->prism1Min < $minMax['prism']['min'])) {
                $minMax['prism']['min'] = $lens->prism1Min;
            }
            if ($lens->prism1Max !== null && ($minMax['prism']['max'] === null || $lens->prism1Max > $minMax['prism']['max'])) {
                $minMax['prism']['max'] = $lens->prism1Max;
            }
        }

        return $minMax;
    }

    /**
     * Get filtered validation data for frontend dropdowns
     * This replaces the client-side filtering logic
     */
    public static function getFilteredValidationData($request)
    {
        // ---- Normalize request to array (supports Request|array) ----
        if ($request instanceof \Illuminate\Http\Request) {
            $request = $request->all();
        } elseif (!is_array($request)) {
            $request = (array) $request;
        }

        // ---- Current user context for price/discount ----
        $user     = auth()->user();
        $profile  = $user->getCustomerAdmin()->profile;
        $priceId  = (int) ($profile->cust_prlist_default ?? 0);
        $discount = (string) ($profile->cust_vsp_office_code ?? 0);

        // expose for callers (not used in base cache key)
        $request['priceId']  = $priceId;
        $request['discount'] = $discount;

        $cacheTag   = app()->environment() . '_rx_validation';
        $catalogTTL = now()->addMonths(12);  // base catalog lasts long
        $pricingTTL = now()->addMonths(12);       // processed response shorter

        // ---- Build base cache key WITHOUT price/discount ----
        $filterKeyRequest = $request;
        unset($filterKeyRequest['priceId'], $filterKeyRequest['discount']);

        $baseKey    = 'rx_filtered_' . hash('crc32', json_encode($filterKeyRequest));
        $pricingKey = $baseKey . "_p{$priceId}_d{$discount}";

        // ---- Fast path: pricing key hit ----
        if (Cache::has($cacheTag . '_' . $pricingKey)) {
            return Cache::get($cacheTag . '_' . $pricingKey);
        }

        // ---- Try to load catalog (base) ----
        $catalog = Cache::get($cacheTag . '_' . $baseKey);

        if (!$catalog) {
            // ---- Build DB query with only FILTER params ----
            $model = self::select('*');

            if (!empty($filterKeyRequest['lens_type'])) {
                $model->where('lens_type', $filterKeyRequest['lens_type']);
            }
            if (!empty($filterKeyRequest['sub_type'])) {
                $model->where('sub_type', 'LIKE', '%' . $filterKeyRequest['sub_type'] . '%');
            }
            if (!empty($filterKeyRequest['lens_name'])) {
                $model->where('lens_name', $filterKeyRequest['lens_name']);
            }
            if (!empty($filterKeyRequest['lens_material'])) {
                $model->where('lens_material', $filterKeyRequest['lens_material']);
            }
            if (!empty($filterKeyRequest['lens_filter'])) {
                $model->where('lens_filter', $filterKeyRequest['lens_filter']);
            }
            if (!empty($filterKeyRequest['lens_colour'])) {
                $model->where('lens_colour', 'LIKE', '%' . $filterKeyRequest['lens_colour'] . '%');
            }
            if (!empty($filterKeyRequest['coating_name'])) {
                $model->where('coating_name', $filterKeyRequest['coating_name']);
            }
            if (!empty($filterKeyRequest['coating_colour'])) {
                $model->where('coating_colour', 'LIKE', '%' . $filterKeyRequest['coating_colour'] . '%');
            }
            if (!empty($filterKeyRequest['base_curve'])) {
                $model->where('base_curve', 'LIKE', '%' . $filterKeyRequest['base_curve'] . '%');
            }
            if (!empty($filterKeyRequest['packages'])) {
                $model->where('packages', 'LIKE', '%' . $filterKeyRequest['packages'] . '%');
            }

            // ---- Prepare base aggregators (independent of price/discount) ----
            $fields = [
                'lens_type', 'lens_manufacturer', 'lens_name', 'sub_type', 'base_curve',
                'lens_material', 'lens_filter', 'lens_colour', 'coating_made',
                'coating_name', 'coating_colour'
            ];

            $fieldsAgg = [];
            foreach ($fields as $f) { $fieldsAgg[$f] = []; }

            $firstId               = null;
            $firstAttrsSnapshot    = [];   // attributes used to build data_values later
            $priceMins             = [];   // e.g. ['Price_1' => 12.34, 'Price_2' => 9.99]
            $discountMins          = [];   // e.g. ['disc_10' => 15, 'disc_20' => 12]
            $packagesMap           = [];   // 'packageName' => [name, price[], prices[], id]
            $selectedPackage       = $filterKeyRequest['packages'] ?? '';

            // ---- Chunk through results to avoid memory blow-ups ----
            $model->chunk(3000, function ($rows) use (
                $fields, &$fieldsAgg, &$firstId, &$firstAttrsSnapshot, 
                &$priceMins, &$discountMins, &$packagesMap, $selectedPackage
            ) {
                foreach ($rows as $row) {
                    // Capture first row info
                    if ($firstId === null) {
                        $firstId = $row->id;
                        // Snapshot only the attributes your getDataValuesAttributes() needs
                        foreach (self::getDataValuesAttributes() as $attr) {
                            $firstAttrsSnapshot[$attr] = $row->$attr ?? null;
                        }
                    }

                    // Build unique lists for fields
                    foreach ($fields as $field) {
                        if (empty($row->$field)) {
                            continue;
                        }

                        if ($field === 'lens_name') {
                            if (!isset($fieldsAgg[$field][$row->lens_manufacturer])) {
                                $fieldsAgg[$field][$row->lens_manufacturer] = [];
                            }
                            $fieldsAgg[$field][$row->lens_manufacturer][$row->$field] = self::decodeValue($row->$field);
                        } elseif ($field === 'lens_filter') {
                            $header = $row->lens_filter_header ?? 'Other';
                            if (!isset($fieldsAgg[$field][$header])) {
                                $fieldsAgg[$field][$header] = [
                                    'sort'    => $row->lens_filter_header_sort ?? 0,
                                    'options' => []
                                ];
                            }
                            $fieldsAgg[$field][$header]['options'][$row->$field] = self::decodeValue($row->$field);
                        } elseif ($field === 'coating_name') {
                            $made = $row->coating_made ?? 'Unknown';
                            if (!isset($fieldsAgg[$field][$made])) {
                                $fieldsAgg[$field][$made] = [];
                            }
                            $fieldsAgg[$field][$made][$row->$field] = self::decodeValue($row->$field);
                        } elseif (in_array($field, ['sub_type', 'lens_colour', 'coating_colour', 'base_curve'], true)) {
                            $values = explode('\\', $row->$field);
                            foreach ($values as $value) {
                                $value = trim($value);
                                if ($value === '') continue;
                                $fieldsAgg[$field][$value] = ($field === 'base_curve') ? $value : self::decodeValue($value);
                            }
                        } else {
                            $fieldsAgg[$field][$row->$field] = self::decodeValue($row->$field);
                        }
                    }

                    // Aggregate min across ALL Price_* columns present on this row
                    $attrs = $row->getAttributes();
                    foreach ($attrs as $key => $val) {
                        if (strpos($key, 'Price_') === 0 && $val !== null && $val !== '') {
                            $num = (float) $val;
                            if (!isset($priceMins[$key]) || $num < $priceMins[$key]) {
                                $priceMins[$key] = $num;
                            }
                        }
                    }

                    // Aggregate min discounts across all disc_* keys inside JSON
                    if (!empty($row->discounts)) {
                        $darr = json_decode($row->discounts, true);
                        if (is_array($darr)) {
                            foreach ($darr as $dkey => $dval) {
                                $dk = strtolower($dkey);
                                if (!is_numeric($dval)) continue;
                                $num = (float) $dval;
                                if (!isset($discountMins[$dk]) || $num < $discountMins[$dk]) {
                                    $discountMins[$dk] = $num;
                                }
                            }
                        }
                    }

                    // Build distinct packages (unique by package name)
                    if (!empty($row->packages)) {
                        $packages       = explode('|', (string) $row->packages);
                        $packagesPriceS = explode('|', (string) ($row->packagesPrice ?? ''));

                        foreach ($packages as $idx => $pkg) {
                            $pkgParts = explode(':', $pkg, 2);
                            if (count($pkgParts) !== 2) continue;

                            $pkgName = trim($pkgParts[1]);
                            // Respect selected package filter if provided
                            if ($selectedPackage && $pkgName !== $selectedPackage) {
                                continue;
                            }

                            $pricesLine = $packagesPriceS[$idx] ?? '';
                            $perTier    = $pricesLine !== '' ? explode('\\', $pricesLine) : [];

                            if (!isset($packagesMap[$pkgName])) {
                                $packagesMap[$pkgName] = [
                                    'name'   => $pkgName,
                                    'price'  => $perTier,        // prices for this package across tiers
                                    'prices' => $packagesPriceS, // full raw list (kept for compatibility)
                                    'id'     => $row->id,
                                ];
                            }

                            // If a single package was requested, we can stop early for this row
                            if ($selectedPackage) {
                                break;
                            }
                        }
                    }
                }
            });

            // Finalize catalog blob for cache
            $catalog = [
                'fields'         => $fieldsAgg,
                'first_id'       => $firstId,
                'first_attrs'    => $firstAttrsSnapshot,
                'price_mins'     => $priceMins,
                'discount_mins'  => $discountMins,  // keys lowercased
                'packages'       => array_values($packagesMap),
            ];

            Cache::put($cacheTag . '_' . $baseKey, $catalog, $catalogTTL);
        }

        // ---- Build processed response from catalog + (priceId, discount) ----
        $priceKey    = 'Price_' . $priceId;
        $discountKey = 'disc_' . strtolower($discount); // catalog stored lowercase

        $response = [
            'price'     => isset($catalog['price_mins'][$priceKey]) ? (float) $catalog['price_mins'][$priceKey] : 0.0,
            'id'        => $catalog['first_id'],
            'packages'  => $catalog['packages'] ?? [],
            'discount'  => isset($catalog['discount_mins'][$discountKey]) ? (float) $catalog['discount_mins'][$discountKey] : 0.0,
        ];

        // Attach field sets
        if (!empty($catalog['fields'])) {
            foreach ($catalog['fields'] as $fname => $vals) {
                $response[$fname] = $vals;
            }
        }

        // ---- data_values (based on first row snapshot, then override price/discount) ----
        $response['data_values'] = [];
        $response['data_values']['price']    = $response['price'];
        $response['data_values']['discount'] = $response['discount'];

        if (!empty($catalog['first_attrs'])) {
            foreach (self::getDataValuesAttributes() as $attribute) {
                $keyValue = $catalog['first_attrs'][$attribute] ?? null;

                // initialize
                if (!isset($response['data_values'][$attribute])) {
                    $response['data_values'][$attribute] = 0;
                }

                // Robust min/max handling
                if (strpos($attribute, 'Min') !== false) {
                    if ($keyValue !== null && $keyValue !== '') {
                        $kv = (float) $keyValue;
                        if ($response['data_values'][$attribute] === 0 || $kv < (float) $response['data_values'][$attribute]) {
                            $response['data_values'][$attribute] = $kv;
                        }
                    }
                    continue;
                } elseif (strpos($attribute, 'Max') !== false) {
                    if ($keyValue !== null && $keyValue !== '') {
                        $kv = (float) $keyValue;
                        if ($response['data_values'][$attribute] === 0 || $kv > (float) $response['data_values'][$attribute]) {
                            $response['data_values'][$attribute] = $kv;
                        }
                    }
                    continue;
                }

                // Complex JSON fields
                if ($response['data_values'][$attribute] === 0 && !empty($keyValue)
                    && in_array($attribute, ['strength', 'corridor', 'corridorSh'], true)) {
                    $decoded = json_decode($keyValue, true);
                    $response['data_values'][$attribute] = $decoded ?: $keyValue;
                    continue;
                }

                // Price fields inside data_values: do not store; just ensure dv.price stays consistent
                if (strpos($attribute, 'Price') !== false) {
                    if (strtolower($attribute) === strtolower($priceKey) && $keyValue !== null && $keyValue !== '') {
                        $kv = (float) $keyValue;
                        if ($response['data_values']['price'] === 0 || $kv < $response['data_values']['price']) {
                            $response['data_values']['price'] = $kv;
                        }
                    }
                    // don't keep individual Price_* attributes
                    unset($response['data_values'][$attribute]);
                    continue;
                }

                // discounts field inside data_values: use it to double-check dv.discount, then remove
                if ($attribute === 'discounts') {
                    $darr = json_decode((string) $keyValue, true);
                    if (is_array($darr)) {
                        $lookupKey = strtolower('disc_' . $discount);
                        if (isset($darr[$lookupKey])) {
                            $dv = (float) $darr[$lookupKey];
                            if ($response['data_values']['discount'] === 0 || $dv < $response['data_values']['discount']) {
                                $response['data_values']['discount'] = $dv;
                            }
                        }
                    }
                    unset($response['data_values'][$attribute]);
                    continue;
                }

                // Generic scalar copy
                if ($response['data_values'][$attribute] === 0) {
                    $response['data_values'][$attribute] = is_numeric($keyValue) ? (float) $keyValue : $keyValue;
                }
            }
        }

        // ---- Cache processed response (pricing layer) ----
        Cache::put($cacheTag . '_' . $pricingKey, $response, $pricingTTL);

        return $response;
    }
}