<?php

namespace App\Models\Backend;

use DB;
use App\Models\Backend\Order;
use Illuminate\Database\Eloquent\Model;

class StockOrder extends Model
{
    CONST BOTH_EYES = 'both_eyes';
    CONST LEFT_EYE  = 'left_eye';
    CONST RIGHT_EYE = 'right_eye';
    CONST BARCODE   = 'barcode';

    public $timestamps = false;

    protected $table = "stock_orders";

    protected $fillable = [
        'id',
        'order_id',
        'type',
        'l_material',
        'l_colour',
        'l_coating',
        'l_sph',
        'l_cyl',
        'l_size',
        'l_quantity',
        'l_price',
        'l_barcode',
        'l_desc',
        'l_vendor',
        'l_cards',
        'r_material',
        'r_colour',
        'r_coating',
        'r_sph',
        'r_cyl',
        'r_size',
        'r_quantity',
        'r_price',
        'r_barcode',
        'r_desc',
        'r_vendor',
        'r_cards'
    ];

    /**
     * @return string
     */
    public function order() {
        return $this->belongsTo(Order::class);
    }

    public function isBoth(){
        return self::BOTH_EYES == $this->type ? true : false;
    }

    public function isLeft(){
        return self::LEFT_EYE == $this->type ? true : false;
    }

    public function isRight(){
        return self::RIGHT_EYE == $this->type ? true : false;
    }

    public function isBarcode(){
        return self::BARCODE == $this->type ? true : false;
    }

    /**
     * Create new stock order
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Order    $order
     * @return \Illuminate\Http\Response
     */
    public static function newStockOrder($order, $request) {

        return DB::transaction(function () use ($order, $request) {
            $type = $request["combinition"];
            switch ($type) {
                case self::BOTH_EYES:
                    $type = self::BOTH_EYES;
                    break;
                case self::LEFT_EYE:
                    $type = self::LEFT_EYE;
                    break;
                case self::RIGHT_EYE:
                    $type = self::RIGHT_EYE;
                    break;
                default:
                    break;
            }

            $stockOrder = parent::create([
                'type'          => $type,
                'l_material'    => isset($request["l_material"]) ? $request["l_material"] : NULL,
                'l_material'    => isset($request["l_material"]) ? $request["l_material"] : NULL,
                'l_colour'      => isset($request["l_colour"])   ? $request["l_colour"]   : NULL,
                'l_coating'     => isset($request["l_coating"])  ? $request["l_coating"]  : NULL,
                'l_sph'         => isset($request["l_sph"])      ? $request["l_sph"]      : NULL,
                'l_cyl'         => isset($request["l_cyl"])      ? $request["l_cyl"]      : NULL,
                'l_size'        => isset($request["l_size"])     ? $request["l_size"]     : NULL,
                'l_quantity'    => isset($request["l_quantity"]) ? $request["l_quantity"] : NULL,
                'l_price'       => isset($request['l_price'])    ? (float) $request['l_price'] : null,
                'l_barcode'       => isset($request["l_barcode"])    ? $request["l_barcode"]    : NULL,
                'l_vendor'       => isset($request["l_vendor"])    ? $request["l_vendor"]    : NULL,
                'l_cards'       => isset($request["l_cards"])    ? $request["l_cards"]    : NULL,
                'r_material'    => isset($request["r_material"]) ? $request["r_material"] : NULL,
                'r_colour'      => isset($request["r_colour"])   ? $request["r_colour"]   : NULL,
                'r_coating'     => isset($request["r_coating"])  ? $request["r_coating"]  : NULL,
                'r_sph'         => isset($request["r_sph"])      ? $request["r_sph"]      : NULL,
                'r_cyl'         => isset($request["r_cyl"])      ? $request["r_cyl"]      : NULL,
                'r_size'        => isset($request["r_size"])     ? $request["r_size"]     : NULL,
                'r_quantity'    => isset($request["r_quantity"]) ? $request["r_quantity"] : NULL,
                'r_price'       => isset($request['r_price'])    ? (float) $request['r_price'] : null,
                'r_barcode'       => isset($request["r_barcode"])    ? $request["r_barcode"]    : NULL,
                'r_vendor'       => isset($request["r_vendor"])    ? $request["r_vendor"]    : NULL,
                'r_cards'       => isset($request["r_cards"])    ? $request["r_cards"]    : NULL,
                'order_id'      => $order->id,
            ]);
            return $stockOrder;
        });
    }

    /**
     * Create new stock order
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Order    $order
     * @return \Illuminate\Http\Response
     */
    public static function newBarCodeOrder($order, $request) {

        return DB::transaction(function () use ($order, $request) {
            $stockOrder = parent::create([
                'type'          => self::BARCODE,
                'l_material'    => $request->material,
                'l_colour'      => $request->colour,
                'l_coating'     => $request->coating,
                'l_sph'         => $request->sph,
                'l_cyl'         => $request->cyl,
                'l_size'        => $request->size,
                'l_quantity'    => 1,
                'l_price'       => $request->price,
                'l_barcode'       => $request->barcode,
                'order_id'      => $order->id,
            ]);
            return $stockOrder;
        });
    }

    /**
     * @return string
     */
    public function leftDetails() {
        if(!empty($this->l_desc)){
            return $this->l_desc.' ['.$this->l_vendor.']';
        }
        $response = $this->l_material.' '.$this->l_colour.' '.$this->l_coating.' '.$this->l_size.'mm';
        if(
            php_sapi_name() === 'cli' || 
            defined('STDIN') || 
            (empty(auth()->user()) 
                || 
                auth()->user()->isAcessible(['view backend'])
            )
        ){
            $response .= '['.$this->l_vendor.']';
        }
        return $response;
    }

    /**
     * @return string
     */
    public function rightDetails() {
        if(!empty($this->r_desc)){
            return $this->r_desc.' ['.$this->r_vendor.']';
        }
        $response = $this->r_material.' '.$this->r_colour.' '.$this->r_coating.' '.$this->r_size.'mm';
        if(
            php_sapi_name() === 'cli' || 
            defined('STDIN') || 
            (empty(auth()->user()) 
                || 
                auth()->user()->isAcessible(['view backend'])
            )
        ){
            $response .= '['.$this->l_vendor.']';
        }
        return $response;
    }
}
