<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

/**
 * Class EventServiceProvider.
 */
class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        'App\Events\UserCreated' => [
            'App\Listeners\UserEventListener',
        ],
        \App\Events\Backend\Auth\csvCustomersUploadingReport::class => [
            \App\Listeners\Backend\Auth\csvCustomerListener::class,
        ],
        \App\Events\Frontend\Auth\CustomerInquiryLog::class => [
            \App\Listeners\Frontend\Auth\CustomerInquiryLogListner::class,
        ],
        \App\Events\Backend\Auth\OrderStatusMail::class => [
            \App\Listeners\Backend\Auth\OrderStatusMailListner::class,
        ],
        \App\Events\Frontend\Auth\CustomerReplied::class => [
            \App\Listeners\Frontend\Auth\CustomerRepliedListner::class,
        ],
        \App\Events\OrderPlaced::class => [
            \App\Listeners\UploadOrderPdfListener::class,
        ],
    ];

    /**
     * Class event subscribers.
     *
     * @var array
     */
    protected $subscribe = [
        // Frontend Subscribers

        // Auth Subscribers
        \App\Listeners\Frontend\Auth\UserEventListener::class,

        // Backend Subscribers

        // Auth Subscribers
        \App\Listeners\Backend\Auth\User\UserEventListener::class,
        \App\Listeners\Backend\Auth\Role\RoleEventListener::class,
    ];

    /**
     * Register any events for your application.
     */
    public function boot()
    {
        parent::boot();

        //
    }

    /**
     * Determine if events and listeners should be automatically discovered.
     *
     * @return bool
     */
    public function shouldDiscoverEvents()
    {
        return false;
    }
}
