<?php

return [
    // Application captcha specific settings
    'captcha' => [
        // Whether the registration captcha is enabled
        'contact' => env('CONTACT_CAPTCHA_STATUS', false),
        'registration' => env('REGISTRATION_CAPTCHA_STATUS', false),
    ],

    // Whether or not registration is enabled
    'registration' => env('ENABLE_REGISTRATION', true),

    // Table names for access tables
    'table_names' => [
        'password_histories' => 'password_histories',
        'users' => 'users',
    ],

    // Eye combination options
    'combinations' => [
        'both_eyes' => 'Both Eyes',
        'left_eye' => 'Left Eye', // Corrected typo from 'Lefy Eye'
        'right_eye' => 'Right Eye',
    ],

    // Default page size for pagination
    'page_size' => 20,
    'list_page_size' => 200,

    // Configurations for the user
    'users' => [
        // Whether users must confirm their email upon registration
        'confirm_email' => env('CONFIRM_EMAIL', false),

        // Whether users can change their email on the edit profile screen
        'change_email' => env('CHANGE_EMAIL', true),

        // Role names
        'admin_role' => 'administrator',
        'lab_manager' => 'lab_manager',
        'lab_staff' => 'lab_staff',
        'customer_admin' => 'customer_admin',
        'customer_staff' => 'customer_staff',

        // Whether new users require admin approval before logging in
        // If true, confirm_email is ignored
        'requires_approval' => env('REQUIRES_APPROVAL', false),

        // Login username fields
        'username' => 'email',
        'customer_username' => 'ac_code',

        // Whether a user can only have one active session at a time
        'single_login' => env('SINGLE_LOGIN', true),

        // Password expiration in days (false to disable)
        'password_expires_days' => env('PASSWORD_EXPIRES_DAYS', false),

        // Number of previous passwords to check when changing/resetting
        'password_history' => env('PASSWORD_HISTORY', false),
    ],

    // Configuration for roles
    'roles' => [
        // Whether a role must contain a permission or can be used as a label
        'role_must_contain_permission' => true,
    ],

    // Socialite session variable name
    'socialite_session_name' => 'socialite_provider',

    // API configurations
    'api' => [
        'twilio_fax' => [
            'sid' => env('TWILIO_FAX_SID'),
            'token' => env('TWILIO_FAX_TOKEN'),
        ],
        'dropbox' => [
            'auth_token' => env('DROPBOX_ACCESS_TOKEN'),
            'client_id' => env('DROPBOX_CLIENT_ID'),
            'secret_id' => env('DROPBOX_SECRET_ID'),
            'order_pdf_upload_path' => env('ORDER_PDF_UPLOAD_FILE_PATH'),
        ],
    ],
];