import {
  dataTables_exports,
  init_dataTables
} from "./chunk-D3GLBO54.js";
import "./chunk-ZZE4QEDJ.js";
import {
  __commonJS,
  __toCommonJS
} from "./chunk-PLDDJCW6.js";

// node_modules/datatables.net-bs4/js/dataTables.bootstrap4.js
var require_dataTables_bootstrap4 = __commonJS({
  "node_modules/datatables.net-bs4/js/dataTables.bootstrap4.js"(exports, module) {
    (function(factory) {
      if (typeof define === "function" && define.amd) {
        define(["jquery", "datatables.net"], function($) {
          return factory($, window, document);
        });
      } else if (typeof exports === "object") {
        module.exports = function(root, $) {
          if (!root) {
            root = window;
          }
          if (!$ || !$.fn.dataTable) {
            $ = (init_dataTables(), __toCommonJS(dataTables_exports))(root, $).$;
          }
          return factory($, root, root.document);
        };
      } else {
        factory(jQuery, window, document);
      }
    })(function($, window2, document2, undefined) {
      "use strict";
      var DataTable = $.fn.dataTable;
      $.extend(true, DataTable.defaults, {
        dom: "<'row'<'col-xs-12 col-md-6'l><'col-xs-12 col-md-6'f>><'row'<'col-xs-12'tr>><'row'<'col-xs-12 col-md-5'i><'col-xs-12 col-md-7'p>>",
        renderer: "bootstrap"
      });
      $.extend(DataTable.ext.classes, {
        sWrapper: "dataTables_wrapper form-inline dt-bootstrap4",
        sFilterInput: "form-control input-sm",
        sLengthSelect: "form-control input-sm",
        sProcessing: "dataTables_processing panel panel-default",
        sPageButton: "paginate_button page-item"
      });
      DataTable.ext.renderer.pageButton.bootstrap = function(settings, host, idx, buttons, page, pages) {
        var api = new DataTable.Api(settings);
        var classes = settings.oClasses;
        var lang = settings.oLanguage.oPaginate;
        var aria = settings.oLanguage.oAria.paginate || {};
        var btnDisplay, btnClass, counter = 0;
        var attach = function(container, buttons2) {
          var i, ien, node, button;
          var clickHandler = function(e) {
            e.preventDefault();
            if (!$(e.currentTarget).hasClass("disabled") && api.page() != e.data.action) {
              api.page(e.data.action).draw("page");
            }
          };
          for (i = 0, ien = buttons2.length; i < ien; i++) {
            button = buttons2[i];
            if ($.isArray(button)) {
              attach(container, button);
            } else {
              btnDisplay = "";
              btnClass = "";
              switch (button) {
                case "ellipsis":
                  btnDisplay = "&#x2026;";
                  btnClass = "disabled";
                  break;
                case "first":
                  btnDisplay = lang.sFirst;
                  btnClass = button + (page > 0 ? "" : " disabled");
                  break;
                case "previous":
                  btnDisplay = lang.sPrevious;
                  btnClass = button + (page > 0 ? "" : " disabled");
                  break;
                case "next":
                  btnDisplay = lang.sNext;
                  btnClass = button + (page < pages - 1 ? "" : " disabled");
                  break;
                case "last":
                  btnDisplay = lang.sLast;
                  btnClass = button + (page < pages - 1 ? "" : " disabled");
                  break;
                default:
                  btnDisplay = button + 1;
                  btnClass = page === button ? "active" : "";
                  break;
              }
              if (btnDisplay) {
                node = $("<li>", {
                  "class": classes.sPageButton + " " + btnClass,
                  "id": idx === 0 && typeof button === "string" ? settings.sTableId + "_" + button : null
                }).append(
                  $("<a>", {
                    "href": "#",
                    "aria-controls": settings.sTableId,
                    "aria-label": aria[button],
                    "data-dt-idx": counter,
                    "tabindex": settings.iTabIndex,
                    "class": "page-link"
                  }).html(btnDisplay)
                ).appendTo(container);
                settings.oApi._fnBindAction(
                  node,
                  { action: button },
                  clickHandler
                );
                counter++;
              }
            }
          }
        };
        var activeEl;
        try {
          activeEl = $(host).find(document2.activeElement).data("dt-idx");
        } catch (e) {
        }
        attach(
          $(host).empty().html('<ul class="pagination"/>').children("ul"),
          buttons
        );
        if (activeEl !== undefined) {
          $(host).find("[data-dt-idx=" + activeEl + "]").focus();
        }
      };
      return DataTable;
    });
  }
});
export default require_dataTables_bootstrap4();
/*! Bundled license information:

datatables.net-bs4/js/dataTables.bootstrap4.js:
  (*! DataTables Bootstrap 3 integration
   * ©2011-2015 SpryMedia Ltd - datatables.net/license
   *)
*/
//# sourceMappingURL=datatables__net-bs4.js.map
