import '../css/app.css';

// Import jQuery
import $ from 'jquery';
window.jQuery = window.$ = $;

// Import Lodash
import _ from 'lodash';
window._ = _;
$.fn.size = function() {
  return this.length;
};

import Popper from 'popper.js';
  window.Popper = Popper;
// Import Bootstrap to extend jQuery with modal and other functions
import 'bootstrap/dist/js/bootstrap.bundle.min.js';


// App is loaded in layout, ensure methods are available
if (window.App) {
  window.App.isAngularJsApp = window.App.isAngularJsApp || (() => false);
  window.App.addResizeHandler = window.App.addResizeHandler || function(handler) {
    $(window).on('resize', handler);
  };
  if (!window.App.getViewPort) {
    window.App.getViewPort = function() {
      var e = window,
          a = 'inner';
      if (!('innerWidth' in window)) {
          a = 'client';
          e = document.documentElement || document.body;
      }
      return {
          width: e[a + 'Width'],
          height: e[a + 'Height']
      };
    };
  }
} else {
  window.App = {
    isAngularJsApp: () => false,
    addResizeHandler: function(handler) {
      $(window).on('resize', handler);
    },
    getResponsiveBreakpoint: function(size) {
      // bootstrap responsive breakpoints
      var sizes = {
        'xs': 0,       // extra small
        'sm': 576,     // small
        'md': 768,     // medium
        'lg': 992,     // large
        'xl': 1200,    // extra large
        'xxl': 1400    // extra extra large
      };
      return sizes[size] ? sizes[size] : 0;
    },
    getViewPort: function() {
      var e = window,
          a = 'inner';
      if (!('innerWidth' in window)) {
          a = 'client';
          e = document.documentElement || document.body;
      }
      return {
          width: e[a + 'Width'],
          height: e[a + 'Height']
      };
    }
  };
}
// console.log('App after fallback:', window.App);

// slimScroll removed, using default scrollbars
window.App.destroySlimScroll = function(element) {
  // No-op, slimScroll removed
};
window.App.initSlimScroll = function(element, options) {
  // No-op, slimScroll removed
};

// Ensure App has required methods
if (window.App) {
  if (!window.App.getResponsiveBreakpoint) {
    window.App.getResponsiveBreakpoint = function(size) {
      var sizes = {
        'xs': 0,
        'sm': 576,
        'md': 768,
        'lg': 992,
        'xl': 1200,
        'xxl': 1400
      };
      return sizes[size] ? sizes[size] : 0;
    };
  }
}

// Non-jQuery dependent imports
import toastr from 'toastr';
window.toastr = toastr;
import moment from 'moment';
window.moment = moment;
import Raphael from 'raphael';
window.Raphael = Raphael;
import List from 'list.js';
window.List = List;
import Swal from 'sweetalert2';
window.Swal = Swal;
import flatpickr from 'flatpickr';
window.flatpickr = flatpickr;
import './customer-account.js';
import('./lab-order-list.js');
import('./notification.js');

// Additional non-jQuery dependent JS imports
import '../assets/global/plugins/linkify/linkify.js';
import '../assets/global/plugins/linkify/linkify-string.js';

// Keep only CSS not already in app.css
import 'datatables.net-bs4/css/dataTables.bootstrap4.css';
import 'datatables.net-buttons-bs4/css/buttons.bootstrap4.css';
import '../css/owl.carousel.min.css';
import '../assets/global/plugins/x-editable/css/bootstrap-editable.css';
import '../assets/global/plugins/fullcalendar/fullcalendar.min.css';
import '../assets/global/plugins/jqvmap/jqvmap/jqvmap.css';
import '../assets/global/plugins/bootstrap-wysihtml5/bootstrap-wysihtml5.css';
import '../assets/global/plugins/bootstrap-markdown/css/bootstrap-markdown.min.css';
import '../assets/css/w3.css';
import 'flatpickr/dist/flatpickr.min.css';
import '../assets/global/plugins/bootstrap-select/dist/css/bootstrap-select.min.css';

// Import jQuery-dependent plugins
  import('datatables.net');
  import('datatables.net-bs4');
  import('datatables.net-buttons');
  import('datatables.net-buttons-bs4');
  import('../assets/pages/scripts/table-datatables-managed.min.js');
  import('../assets/global/plugins/js.cookie.min.js');
  import('../assets/global/plugins/jquery.blockui.min.js');
  import('../assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js');
  import('../assets/pages/scripts/components-bootstrap-switch.min.js');
  import('./jquery.magnific-popup.js');
  import('../assets/global/plugins/morris/morris.min.js');
  import('../assets/global/plugins/counterup/jquery.counterup.min.js');
  import('../assets/pages/scripts/dashboard.min.js');
  import('../assets/global/plugins/jquery-validation/js/jquery.validate.min.js').then(() => {
    import('../assets/global/plugins/jquery-validation/js/additional-methods.min.js');
  });
  import('./frames.js');
  import('./filter.js');
  import('./scroll.js');
  import('../assets/global/plugins/bootstrap-fileinput/bootstrap-fileinput.js');
  import 'dropify/dist/js/dropify.js';
  import 'dropzone/dist/dropzone.css';
  import Dropzone from 'dropzone';
  window.Dropzone = Dropzone;
  import('../assets/global/plugins/icheck.js').then(() => {
    import('../assets/pages/scripts/form-icheck.min.js');
  });
  import('../assets/layouts/layout/scripts/layout.min.js');
  import('../assets/layouts/layout/scripts/demo.min.js');
  import('../assets/layouts/global/scripts/quick-sidebar.min.js');
  import('../assets/layouts/global/scripts/quick-nav.min.js');
  import('../assets/global/plugins/pace/pace.min.js');
  import('../assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js');
  import('../assets/global/plugins/bootstrap-select/dist/js/bootstrap-select.min.js');
  import('../assets/global/plugins/select2/js/select2.full.min.js');
  import('../assets/pages/scripts/components-select2.min.js');
  import('../assets/global/plugins/jquery-inputmask/jquery.inputmask.bundle.min.js');
  import('../assets/global/plugins/bootstrap-sweetalert/sweetalert.min.js');
  import('../assets/global/scripts/app.min.js');
  import('../assets/global/plugins/linkify/linkify-jquery.js').then(() => {
    import('./my-custom.js');
  });
  import('./consumables.js');
  import('./cron.js');
  import('./order.js');
  import('./chatbot.js');
  // Additional jQuery dependent imports
  import('../assets/global/plugins/owl-carousel/owl.carousel.min.js');