// Filter functionality extracted from my-custom.js and frames.js

// Filter checkbox change handler from my-custom.js
$('.filter-checbox :checkbox').on('change',function(e){
    var array = [];
    $('.filter-checbox :checkbox:checked').each(function (key, val) {
       array[key] = (this.checked ? $(this).val() : "");
    });
    blockUIFlag = false;
    var urlParam = '?types='+JSON.stringify(array);
    var element = $('#load-more-btn');
    var tableElement = $('.'+$('#load-more-btn').attr('data-attr'));
    loadMoreAjax(element,tableElement,urlParam);
});

// Column filter functions from frames.js
let columnFilters = {};

const showFilterDropdown = function(columnIndex, th) {
    console.log('showFilterDropdown called for column:', columnIndex, 'from element:', th);
    let dropdown = document.getElementById('filter-dropdown');
    if (!dropdown) {
        dropdown = document.createElement('div');
        dropdown.id = 'filter-dropdown';
        dropdown.className = 'filter-dropdown';
        // Add essential styling for visibility and positioning
        dropdown.style.position = 'absolute';
        dropdown.style.zIndex = '10000'; // A very high z-index to ensure it's on top
        dropdown.style.backgroundColor = '#fff'; // White background
        dropdown.style.border = '1px solid #ccc'; // Light gray border
        dropdown.style.boxShadow = '0 2px 10px rgba(0,0,0,0.1)'; // Subtle shadow
        dropdown.style.minWidth = '200px'; // Ensure it has a minimum width
        document.body.appendChild(dropdown);
    }

    const table = document.getElementById('frameTable');
    const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');
    const uniqueValues = new Set();

    for (let i = 0; i < rows.length; i++) {
        const cell = rows[i].getElementsByTagName('td')[columnIndex];
        if (cell) {
            uniqueValues.add(cell.textContent || cell.innerText);
        }
    }

    const existingFilter = columnFilters[columnIndex];

    let dropdownHtml = `
        <div class="filter-dropdown-content">
            <input type="text" class="form-control form-control-sm" onkeyup="filterDropdownSearch(this, ${columnIndex})" placeholder="Search...">
            <div class="filter-dropdown-items">
                <div><input type="checkbox" onchange="toggleSelectAll(this, ${columnIndex})" ${!existingFilter || existingFilter.size === uniqueValues.size ? 'checked' : ''}> (Select All)</div>
    `;

    uniqueValues.forEach(value => {
        const isChecked = !existingFilter || existingFilter.has(value);
        dropdownHtml += `<div><input type="checkbox" class="filter-item" value="${value}" ${isChecked ? 'checked' : ''}> ${value}</div>`;
    });

    dropdownHtml += `
            </div>
            <div class="filter-dropdown-buttons">
                <button class="btn btn-primary btn-sm" onclick="applyColumnFilter(${columnIndex})">Apply</button>
                <button class="btn btn-secondary btn-sm" onclick="clearColumnFilter(${columnIndex})">Clear</button>
                <button class="btn btn-secondary btn-sm" onclick="closeFilterDropdown()">Cancel</button>
            </div>
        </div>
        `;

    dropdown.innerHTML = dropdownHtml;
    dropdown.style.display = 'block';
    const rect = th.getBoundingClientRect();
    dropdown.style.left = rect.left + 'px';
    dropdown.style.top = rect.bottom + 'px';
}

const filterDropdownSearch = function(input, columnIndex) {
    const filter = input.value.toUpperCase();
    const dropdown = document.getElementById('filter-dropdown');
    const items = dropdown.getElementsByClassName('filter-item');

    for (let i = 0; i < items.length; i++) {
        const value = items[i].value;
        if (value.toUpperCase().indexOf(filter) > -1) {
            items[i].parentElement.style.display = "";
        } else {
            items[i].parentElement.style.display = "none";
        }
    }
}

const toggleSelectAll = function(checkbox, columnIndex) {
    const dropdown = document.getElementById('filter-dropdown');
    const items = dropdown.getElementsByClassName('filter-item');
    for (let i = 0; i < items.length; i++) {
        items[i].checked = checkbox.checked;
    }
}

const applyColumnFilter = function(columnIndex) {
    const dropdown = document.getElementById('filter-dropdown');
    const items = dropdown.getElementsByClassName('filter-item');
    const selectedValues = new Set();

    for (let i = 0; i < items.length; i++) {
        if (items[i].checked) {
            selectedValues.add(items[i].value);
        }
    }

    columnFilters[columnIndex] = selectedValues;

    const table = document.getElementById('frameTable');
    const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

    for (let i = 0; i < rows.length; i++) {
        const cell = rows[i].getElementsByTagName('td')[columnIndex];
        if (cell) {
            const cellValue = cell.textContent || cell.innerText;
            if (selectedValues.has(cellValue)) {
                rows[i].style.display = "";
            } else {
                rows[i].style.display = "none";
            }
        }
    }

    const th = document.querySelector(`.filter-th:nth-child(${columnIndex + 1})`);
    const filterBtn = th.querySelector('.filter-btn i');
    filterBtn.classList.remove('fa-caret-down');
    filterBtn.classList.add('fa-filter');

    closeFilterDropdown();
}

const clearColumnFilter = function(columnIndex) {
    delete columnFilters[columnIndex];

    const table = document.getElementById('frameTable');
    const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

    for (let i = 0; i < rows.length; i++) {
        rows[i].style.display = "";
    }

    const th = document.querySelector(`.filter-th:nth-child(${columnIndex + 1})`);
    const filterBtn = th.querySelector('.filter-btn i');
    filterBtn.classList.remove('fa-filter');
    filterBtn.classList.add('fa-caret-down');

    closeFilterDropdown();
}

const closeFilterDropdown = function() {
    const dropdown = document.getElementById('filter-dropdown');
    dropdown.style.display = 'none';
}

// Make functions global
window.showFilterDropdown = showFilterDropdown;
window.filterDropdownSearch = filterDropdownSearch;
window.toggleSelectAll = toggleSelectAll;
window.applyColumnFilter = applyColumnFilter;
window.clearColumnFilter = clearColumnFilter;
window.closeFilterDropdown = closeFilterDropdown;