const init = function() {
        const pageContent = document.querySelector('.page-content');
        const listItems = document.querySelectorAll('li');
        // const headerClass = document.querySelector('.navbar-fixed-top');
        let groupedRows = {};

        listItems.forEach(listItem => {
            listItem.addEventListener('click', function() {
                const anchor = this.querySelector('a');
                if (anchor) {
                    const anchorId = anchor.getAttribute('id');

                    if (anchorId !== 'loadFrameGrid') {
                        const colMd3 = document.querySelector('.col-md-2');
                        const colMd9 = document.querySelector('.col-md-10');

                        if (colMd3) colMd3.classList.remove('extend-width');
                        if (colMd9) colMd9.classList.remove('grid-container');

                        if(pageContent){
                            pageContent.style.maxWidth = '';
                            // headerClass.style.maxWidth = '1550px';
                            // headerClass.style.margin = 'auto';
                        }
                    } else {
                        const colMd3 = document.querySelector('.col-md-2');
                        const colMd9 = document.querySelector('.col-md-10');

                        if (colMd3) colMd3.classList.add('extend-width');
                        if (colMd9) colMd9.classList.add('grid-container');

                        if(pageContent){
                           pageContent.style.maxWidth = '100%';
                        //    headerClass.style.maxWidth = '100%';
                        }
                    }
                }
            });
        });

        // Utility functions
        const formatPrice = (price) => price ? `$${parseFloat(price).toFixed(2)}` : '';
        const cleanText = (text) => text ? text.replace(/[\\/]/g, '') : '';

        // Remove 'frameGroupingActive' item from localStorage when the page loads
        localStorage.removeItem('frameGroupingActive');

        const handlePackageStorage = function()
        {
            let packageDropdown = document.querySelector('#packageDropdown');
            let selectedOption = packageDropdown.options[packageDropdown.selectedIndex];
            let selectedPackageId = selectedOption.id;
            localStorage.setItem('selectedPackageId', selectedPackageId);
        }

        const handlePriceFilterStorage = function()
        {
            let priceDropdown = document.querySelector('#priceDropdown');
            let selectedOption = priceDropdown.options[priceDropdown.selectedIndex];
            let selectedPriceFilterId = selectedOption.id;
            localStorage.setItem('selectedPriceFilterId', selectedPriceFilterId);
        }

        const handleStatusFilterStorage = function()
        {
            let statusDropdown = document.querySelector('#statusDropdown');
            let selectedOption = statusDropdown.options[statusDropdown.selectedIndex];
            let selectedStatusFilterId = selectedOption.id;
            localStorage.setItem('selectedStatusFilterId', selectedStatusFilterId);
        }

        const handleManufacturerStorage = function()
        {
            let manufacturerDropdown = document.querySelector('#manufacturerDropdown');
            let selectedOption = manufacturerDropdown.options[manufacturerDropdown.selectedIndex];
            let selectedManufacturerId = selectedOption.id;
            localStorage.setItem('selectedManufacturerId', selectedManufacturerId);
            const selectedBrandId = localStorage.getItem('selectedBrandId');
            if (selectedBrandId !== null) {
                localStorage.removeItem('selectedBrandId');
            }
            const selectedModelName = localStorage.getItem('selectedModelName');
            if (selectedModelName !== null) {
                localStorage.removeItem('selectedModelName');
            }
        }

        const handleBrandStorage = function()
        {
            let brandDropdown = document.querySelector('#brandDropdown');
            let selectedOption = brandDropdown.options[brandDropdown.selectedIndex];
            let selectedBrandId = selectedOption.id;
            localStorage.setItem('selectedBrandId', selectedBrandId);
            const selectedModelName = localStorage.getItem('selectedModelName');
            if (selectedModelName !== null) {
                localStorage.removeItem('selectedModelName');
            }
        }

        const handleModelStorage = function()
        {
            let modelDropdown = document.querySelector('#modelDropdown');
            let selectedOption = modelDropdown.options[modelDropdown.selectedIndex];
            let selectedModelName = selectedOption.value;
            localStorage.setItem('selectedModelName', selectedModelName);
        }

        // Function to validate frameGrouping Active/InActive
        const frameGroupingIsActive = function() {

            let frameGroupingActive;
            if(localStorage.getItem('frameGroupingActive') ==1 ) {
                frameGroupingActive = true;  //Active
            } else {
                frameGroupingActive = false; //InActive
            }
            return frameGroupingActive;
        }

        const importInHouseModel = function() {
            $('#importModal').modal('show');
        }

        const formatTimestamp = function(date) {
            const months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
            const day = date.getDate();
            const month = months[date.getMonth()];
            const year = date.getFullYear();
            let hours = date.getHours();
            const minutes = date.getMinutes().toString().padStart(2, '0');
            const ampm = hours >= 12 ? 'pm' : 'am';
            hours = hours % 12;
            hours = hours ? hours : 12;
            return `${day}-${month}-${year} ${hours}:${minutes} ${ampm}`;
        }

        // For links with class 'loadFrameGrid', trigger AJAX on click
        $(document).on('click', '#loadFrameGrid', function()
        {
            const filterId = $(this).data('filter-id');
            document.getElementsByClassName('cron-alert')[0].style.display = 'none';
            loadFrameGrid(filterId);
        });

        $(document).on('click','#resetButton ',function(event)
        {
            localStorage.removeItem('selectedManufacturerId');
            localStorage.removeItem('selectedBrandId');
            localStorage.removeItem('selectedModelName');
            localStorage.removeItem('frameGroupingActive');
            localStorage.removeItem('selectedPackageId');
            localStorage.removeItem('selectedPriceFilterId');
            localStorage.removeItem('selectedStatusFilterId');
            // document.getElementById('loadFrameGrid').click();
        });

        const hideToggleButtonForChildRows = function() {
        // First count occurrences of each model
        const modelCounts = {};
        $("tr[data-model-id]").each(function() {
            const modelId = $(this).data("model-id");
            modelCounts[modelId] = (modelCounts[modelId] || 0) + 1;
        });

        $(".group-toggle-btn").each(function() {
            const parentRow = $(this).closest(".frameRow");
            const modelId = parentRow.data("model-id");
            
            // Only show toggle for models with multiple rows
            if (modelCounts[modelId] > 1) {
                const isFirstRow = parentRow.index() === $("tr[data-model-id='" + modelId + "']").first().index();
                
                if (isFirstRow) {
                    parentRow.addClass('parent-row').data('is-expanded', true);
                    $(this).html('<i class="fa fa-minus-square-o"></i>');
                } else {
                    parentRow.addClass('child-row');
                    $(this).hide();
                }
            } else {
                $(this).hide();
            }
        });

        // Initially hide all child rows
        // $('.child-row').hide();

       // Updated toggle button click handler
        $(document).off("click", ".group-toggle-btn").on("click", ".group-toggle-btn", function() {
            let button = $(this);
            let parentRow = button.closest(".frameRow");
            let modelId = parentRow.data("model-id");
            let isExpanded = parentRow.data('is-expanded');
            let childRows = $(`tr.child-row[data-model-id="${modelId}"]`);
            let totalRows = $(`tr[data-model-id="${modelId}"]`);
            
            if (isExpanded) {
                childRows.slideUp(500);
                button.html('<i class="fa fa-plus-square-o"></i>');
                let countSpan = $("<span>")
                    .addClass("collapsed-count")
                    .text(` (${totalRows.length})`);
                button.append(countSpan);
                parentRow.data('is-expanded', false);
            } else {
                childRows.slideDown(500);
                button.html('<i class="fa fa-minus-square-o"></i>');
                button.find(".collapsed-count").remove();
                parentRow.data('is-expanded', true);
            }
        });
    }

        const populateGroupedRows = function() {
            groupedRows = {}; // Reset
            $('tr[data-model-id]').each(function () {
                let modelId = $(this).data('model-id');
                if (!groupedRows[modelId]) {
                    groupedRows[modelId] = [];
                }
                groupedRows[modelId].push($(this));
            });
        }



        // Allow only numeric values in the input box
        $(document).on('input', '.input-class-price', function()
        {
            // Remove non-numeric characters (except decimal point)
            var value = $(this).val();
            var numericValue = value.replace(/[^0-9.]/g, ''); // Remove anything that's not a number or a decimal point

            // Optional: Allow only one decimal point
            if (numericValue.split('.').length > 2) {
                numericValue = numericValue.replace(/\.+$/, ''); // Remove extra decimal points
            }
            $(this).val(numericValue);
        });


        // Function to handle common logic for 'tier, Price, Charge'
        const handleChangeEvent = function(event, type, selectorClass) {
            let selectedVal = event.target.value;
            let selectType;
            let isFrameGroupingActive = frameGroupingIsActive();
            let dynamicId;
            let trElement = $(event.target).closest('tr');
            let countValue = 0;
            let toggleBtn = trElement.find(".group-toggle-btn");
            let spanCount = toggleBtn.find(".collapsed-count").text().match(/\d+/);
            if (spanCount) {
                countValue = 1;
            }
            if (isFrameGroupingActive || countValue) {
                selectType = 'frame';
                dynamicId = trElement.data('model-id');
            } else {
                selectType = 'model';
                dynamicId = trElement.attr('configurationfpc');
            }

            // Handle different input types
            if (type === 'non_rx' || type === 'out_edge') {
                selectedVal = $(event.target).is(':checked') ? '1' : '0';
            } 
            else if (type === 'price' && selectedVal !== "") {
                selectedVal = parseFloat(selectedVal.replace(/[^0-9.]/g, ""));
            }
            // For measurement fields (A, B, ED, DBL)
            else if (['A', 'B', 'ED', 'DBL'].includes(type)) {
                // Only proceed if there's a value (for measurements)
                if (!selectedVal.trim()) return;
            }

            $.ajax({
                url: '/save-tier-price',
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    selectedTierPrice: {
                        dynamicId,
                        selectedVal,
                        type,
                        selectType,
                        onlyUpdateEmpty: ['A', 'B', 'ED', 'DBL'].includes(type)
                    }
                },
                success: function (response) {
                    if (isFrameGroupingActive || countValue) {
                        const tableRow = document.querySelectorAll(`tr[data-model-id="${dynamicId}"]`);
                        tableRow.forEach(function (row) {
                            let selector = row.querySelector(selectorClass);
                            // Special handling for checkboxes
                            if (type === 'non_rx' || type === 'out_edge') {
                                selector.checked = (selectedVal === '1');
                            } else if (['A', 'B', 'ED', 'DBL'].includes(type)) {
                                // Keep as input field since we're only saving to direct columns
                                $(selector).val(selectedVal);
                            } else {
                                selector.value = selectedVal;
                            }
                        });
                    }
                    // Show success feedback for measurements
                    if (['A', 'B', 'ED', 'DBL'].includes(type)) {
                        $(event.target).addClass('saved-successfully');
                        setTimeout(() => {
                            $(event.target).removeClass('saved-successfully');
                        }, 1000);
                    }
                    return true;
                },
                error: function (xhr, status, error) {
                    Swal.fire({
                        title: "Oops...",
                        text: error,
                        icon: status
                    });
                    // Show error feedback for measurements
                    if (['A', 'B', 'ED', 'DBL'].includes(type)) {
                        $(event.target).addClass('save-error');
                        setTimeout(() => {
                            $(event.target).removeClass('save-error');
                        }, 1000);
                    }
                }
            });
        }


        // Initialize all dropdown handlers
        const initializeDropdownHandlers = function() {
            // Remove any existing handlers first
            $(document).off('change', '.tier-dropdown')
                       .off('change', '.charge-dropdown')
                       .off('change', '.package-checkbox')
                       .off('change', '.non-rx-checkbox')
                       .off('change', '.out-edge-checkbox') 
                       .off('keydown', '.input-class-price');

            // Tier dropdown handler
            $(document).on('change', 'select.tier-dropdown', function(event) {
                event.stopImmediatePropagation();
                handleChangeEvent(event, 'tier', '.tier-dropdown');
            });

            // Charge dropdown handler
            $(document).on('change', 'select.charge-dropdown', function(event) {
                event.stopImmediatePropagation();
                handleChangeEvent(event, 'charge', '.charge-dropdown');
            });

            // Package checkbox handler - CHANGED TO INPUT
            $(document).on('change', 'input.package-checkbox', function(event) {
                event.stopImmediatePropagation();
                handlePackageCheckboxChange(this);
            });

            // Non-RX checkbox handler - NEW HANDLER
            $(document).on('change', 'input.non-rx-checkbox', function(event) {
                event.stopImmediatePropagation();
                handleChangeEvent(event, 'non_rx', '.non-rx-checkbox');
            });

            // Out-Edge checkbox handler
            $(document).on('change', 'input.out-edge-checkbox', function(event) {
                event.stopImmediatePropagation();
                handleChangeEvent(event, 'out_edge', '.out-edge-checkbox');
            });

            $(document).on('keydown', '.input-class-price', function(event) {
                // Only handle Enter key (keyCode 13)
                if (event.key === 'Enter') {
                    event.preventDefault(); // Prevent form submission
                    event.stopPropagation(); // Stop event bubbling
                    let value = $(this).val().trim();
                    
                    // Allow empty value (to clear the price)
                    if (value === '') {
                        handleChangeEvent(event, 'price', '.input-class-price');
                        $(this).blur();
                        return;
                    }
                    
                    // Validate non-empty input
                    if (isNaN(parseFloat(value))) {
                        console.warn('Invalid price value:', value);
                        return;
                    }
                    
                    // Trigger the API call for valid numbers
                    handleChangeEvent(event, 'price', '.input-class-price');
                    $(this).blur();
                }
            });

            // Add handler for measurement fields
            $(document).on('blur', '.editable-frame-field', function(event) {
                const field = $(this).data('field');
                handleChangeEvent(event, field, `.editable-frame-field[data-field="${field}"]`);
            });
            
        }
        // Call this after content loads
        $(document).ready(function() {
            initializeDropdownHandlers();
        });

        // Extracted package checkbox logic to separate function
        const handlePackageCheckboxChange = function(checkbox) {
            let packageRes = {};
            let $checkbox = $(checkbox);
            let packageId = $checkbox.attr('data-package-id');
            let packageName = $checkbox.val();
            let modelId = $checkbox.attr('data-model-id');
            let manufacturerId = $checkbox.attr('data-manufacturer-id');
            let brandId = $checkbox.attr('data-brand-id');
            let configurationFPC = $checkbox.attr('configurationFPC');
            let isFrameGroupingActive = frameGroupingIsActive();
            let isChecked = $checkbox.prop('checked');
            let parentRow = $checkbox.closest('.frameRow');
            let countValue = 0;

            // Check for collapsed state
            if (parentRow.find('.collapsed-count').text().trim() !== '') {
                countValue = 1;
            }

            let selectType = (isFrameGroupingActive || countValue) ? 'frame' : 'model';
            let dynamicId = (isFrameGroupingActive || countValue) ? modelId : configurationFPC;

            packageRes[packageId] = packageName;
            let packageResponse = JSON.stringify(packageRes);
            let action = isChecked ? 'save' : 'unset';

            $.ajax({
                url: '/save-packages',
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    selectedPackages: {
                        dynamicId, 
                        packageResponse, 
                        manufacturerId, 
                        brandId, 
                        configurationFPC, 
                        action, 
                        selectType
                    }
                },
                success: function(response) {
                    // Handle success for frame grouping
                    if (isFrameGroupingActive || countValue) {
                        $(`.package-checkbox[data-model-id="${modelId}"][value="${packageName}"]`)
                            .prop('checked', isChecked);

                        let $rows = $(`tr[data-model-id="${modelId}"]`);
                        let anyChecked = $rows.find('.package-checkbox:checked').length > 0;

                        $rows.find('.tier-dropdown')
                            .prop('disabled', !anyChecked)
                            .val(anyChecked ? 1 : 0);
                    } 
                    // Handle success for single model
                    else {
                        let $row = $(`tr[configurationFPC="${configurationFPC}"]`);
                        let anyChecked = $row.find('.package-checkbox:checked').length > 0;
                        
                        $row.find('.tier-dropdown')
                            .prop('disabled', !anyChecked)
                            .val(anyChecked ? 1 : 0);
                    }
                },
                error: function(xhr) {
                    Swal.fire({
                        title: "Error",
                        text: xhr.responseJSON?.message || 'An error occurred',
                        icon: "error"
                    });
                    // Revert checkbox state on error
                    $checkbox.prop('checked', !isChecked);
                }
            });
        }    

        // Show package image popup on click
        const showFrameImage = function(image)
        {
            const manufacturerId = image.getAttribute('mid');
            const upc   = image.getAttribute('upc');
            if(upc == "") return true;
            $.ajax({
                url: '/get-frame-image',
                    type: 'GET',
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {
                        manufacturer_id: manufacturerId,
                        upc: upc
                    },
                success: function(response) {
                    if (response.imageUrl) {
                        image.src = response.imageUrl;
                        $('#modalImg').attr('src',image.src);
                        $('#main-model').modal({show:true})
                    } else {
                        image.src = "";
                    }
                },
                error: function(error) {
                    image.src = "";
                }
            });
        }

        $(document).on('submit', '#csvImportForm', function(e) {
            e.preventDefault();
            var formData = new FormData(this);
            $.ajax({
                url: '/import-model',
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: formData,
                contentType: false,
                processData: false,
                success: function (response) {
                    if (response.success) {
                        Swal.fire({
                            title: 'Success!',
                            text: response.message,
                            timer: 3000,
                            icon: "success",
                            confirmButtonText: 'Great!'
                        });
                        $('#importModal').modal('hide');
                    } else {
                        $('#importModal').modal('hide');
                        Swal.fire({
                            title: "Oops...",
                            text: 'Failed to import CSV!',
                            icon: "error",
                            timer: 3000,
                            });
                    }
                },
                error: function(xhr, status, error) {
                    $('#importModal').modal('hide');
                    Swal.fire({
                        title: "Oops...",
                        text: xhr.responseJSON.message,
                        icon: "error",
                        timer: 3000,
                    });
                }
            });
        });

        const applyGroupingState = function() {
            if (localStorage.getItem('frameGroupingActive') == 1) {
                setTimeout(() => {
                    $('#frameGrouping').prop('checked', true).trigger('change');
                }, 100);
            }
        }

        // Code to restrict price field upto 2 decimal

        document.addEventListener('input', function (event) {
            if (event.target.classList.contains('input-class-price')) {
                let value = event.target.value;
                // Remove any non-numeric characters except decimal point
                value = value.replace(/[^0-9.]/g, '');
                // Ensure only one decimal point
                if ((value.match(/\./g) || []).length > 1) {
                    value = value.replace(/\.+$/, ''); // Remove extra decimal points
                }
                // Restrict to 2 decimal places
                let decimalIndex = value.indexOf('.');
                if (decimalIndex !== -1 && value.length - decimalIndex > 3) {
                    value = value.substring(0, decimalIndex + 3); // Truncate to 2 decimal places
                }
                // Update the input value
                event.target.value = value;
            }
        });


        const exportToCSV = async function() {
            try {
                Swal.fire({
                    title: 'Preparing CSV Export',
                    html: 'Please wait while we gather all filtered records...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                // Get all filter values from localStorage
                const selectedPackageId = localStorage.getItem('selectedPackageId');
                const selectedPriceFilterId = localStorage.getItem('selectedPriceFilterId');
                const selectedStatusFilterId = localStorage.getItem('selectedStatusFilterId');
                const selectedManufacturerId = localStorage.getItem('selectedManufacturerId');
                const selectedBrandId = localStorage.getItem('selectedBrandId');
                const selectedModelName = localStorage.getItem('selectedModelName');
                const frameGroupingActive = localStorage.getItem('frameGroupingActive') == 1;

                // Get the complete filtered dataset from the server
                const response = await $.ajax({
                    url: $('#frameData').attr('data-brand-index'),
                    method: "GET",
                    data: {
                        'package': selectedPackageId,
                        'price': selectedPriceFilterId,
                        'status': selectedStatusFilterId,
                        'manufacturer': selectedManufacturerId,
                        'brand': selectedBrandId,
                        'model': selectedModelName,
                        'export': true // Add a flag to tell the server to return all records
                    }
                });

                // If no data, show error and return
                if (!response.stylesCollection || response.stylesCollection.length === 0) {
                    Swal.fire({
                        title: 'No Data',
                        text: 'There are no records to export',
                        icon: 'warning'
                    });
                    return;
                }

                // Prepare CSV headers
                const headers = [ 'Packages', 'Tier', 'Price', 'Charge Type', 'Non-RX', 'Out-Edge', 'Manufacturer', 'Brand', 'Model', 'Color', 'Size', 'Color Code', 'A', 'B', 'ED', 'DBL', 'ED Angle', 'Rim', 'Edge Type', 'UPC', 'Configuration FPC', 'SKU',
                    'Status', 'Material', 'Precious Metal', 'Frame Shape', 'RX', 'Frame Type', 'Lens Color', 'Lens Color Code' 
                ];

                // Initialize CSV content with headers
                const csvRows = [headers.join(',')];

                // Process each record
                response.stylesCollection.forEach(style => {
                    try {
                        style.frame_style_data = typeof style.frame_style_data === 'string' 
                            ? JSON.parse(style.frame_style_data) 
                            : style.frame_style_data || {};

                        // Get package names (checked packages)
                        const packageData = style.package_data ? JSON.parse(style.package_data) : {};
                        const packageNames = Object.values(packageData).join(', ');

                        // Get tier and charge names from collections
                        const tierName = response.tierCollection[style.tier] || '';
                        const chargeName = response.chargeCollection[style.charge] || '';

                        // Format size
                        const sizeParts = [
                            style.frame_style_data.EyeSize,
                            style.frame_style_data.BridgeSize,
                            style.frame_style_data.TempleLength
                        ].filter(Boolean);
                        const size = sizeParts.join(' - ');

                        // Create row data
                        const rowData = [
                            `"${packageNames}"`, 
                            `"${tierName}"`, 
                            `"${style.price ? parseFloat(style.price).toFixed(2) : ''}"`, 
                            `"${chargeName}"`, 
                            `"${style.non_rx == '1' ? 'Yes' : 'No'}"`, 
                            `"${style.out_edge == '1' ? 'Yes' : 'No'}"`, 
                            `"${cleanText(style.frame_style_data.ManufacturerName || '')}"`, 
                            `"${cleanText(style.frame_style_data.BrandName || '')}"`, 
                            `"${cleanText(style.name || '')}"`, 
                            `"${style.frame_style_data.FrameColor || ''}"`, 
                            `"${size}"`, 
                            `"${style.frame_style_data.FrameColorCode || ''}"`, 
                            `"${style.frame_style_data.A || style.A || ''}"`, 
                            `"${style.frame_style_data.B || style.B || ''}"`, 
                            `"${style.frame_style_data.ED || style.ED || ''}"`, 
                            `"${style.frame_style_data.DBL || style.DBL || ''}"`, 
                            `"${style.frame_style_data.EDAngle || ''}"`, 
                            `"${style.frame_style_data.Rim || ''}"`, 
                            `"${style.frame_style_data.EdgeType || ''}"`, 
                            `"${style.frame_style_data.UPC || ''}"`, 
                            `"${style.frame_style_data.ConfigurationFPC || ''}"`, 
                            `"${style.frame_style_data.SKU || ''}"`, 
                            `"${style.status || ''}"`, 
                            `"${style.frame_style_data.Material || ''}"`, 
                            `"${style.frame_style_data.PreciousMetal || ''}"`, 
                            `"${cleanText(style.frame_style_data.FrameShape) || ''}"`, 
                            `"${style.frame_style_data.RX || ''}"`, 
                            `"${style.frame_style_data.FrameType || ''}"`, 
                            `"${style.frame_style_data.LensColor || ''}"`, 
                            `"${style.frame_style_data.LensColorCode || ''}"` 
                        ];

                        csvRows.push(rowData.join(','));
                    } catch (error) {
                        console.error('Error processing row:', style, error);
                    }
                });

                // Create CSV content
                const csvContent = csvRows.join('\n');

                // Create and trigger download
                const blob = new Blob([csvContent], { type: 'text/csv;charset=utf-8;' });
                const link = document.createElement('a');
                link.href = URL.createObjectURL(blob);
                link.download = `frames_export_${new Date().toISOString().slice(0,10)}.csv`;
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);

                // Close loading indicator
                Swal.close();
            } catch (error) {
                console.error('Export failed:', error);
                Swal.fire({
                    title: 'Export Failed',
                    text: error.message || 'An error occurred during export',
                    icon: 'error'
                });
            }
        }

        const loadFrameGrid = function(priceFilter=null, packageFilter=null, manufacturerFilter=null, brandFilter=null, modelFilter=null, statusFilter=null, type, pageUrl) {
            $('.col-md-2').addClass('extend-width');
            $('.col-md-10').addClass('grid-container');
            pageContent.style.maxWidth = 'inherit';
            pageContent.style.width = '100%';
            pageContent.style.maxWidth = '100%';
            let brandIndexUrl = $('#frameData').attr('data-brand-index');
            // Show loading indicator if needed
            
            // Get all filter values from localStorage if not provided
            const selectedPackageId = packageFilter || localStorage.getItem('selectedPackageId');
            const selectedPriceFilterId = priceFilter || localStorage.getItem('selectedPriceFilterId');
            const selectedStatusFilterId = statusFilter || localStorage.getItem('selectedStatusFilterId');
            const selectedManufacturerId = manufacturerFilter || localStorage.getItem('selectedManufacturerId');
            const selectedBrandId = brandFilter || localStorage.getItem('selectedBrandId');
            const selectedModelName = modelFilter || localStorage.getItem('selectedModelName');
            const frameGroupingActive = localStorage.getItem('frameGroupingActive') == 1;
            // Make single API call
            $.ajax({
                url: pageUrl || $('#frameData').attr('data-brand-index'),
                method: "GET",
                data: {
                    'package': selectedPackageId,
                    'price': selectedPriceFilterId,
                    'status': selectedStatusFilterId,
                    'manufacturer': selectedManufacturerId,
                    'brand': selectedBrandId,
                    'model': selectedModelName,
                    'load_header': true // Flag to get header data
                },
                success: function(response) {
                    // Update header if response contains header data
                    if (response.headerHtml) {
                        $('#frameHeader').html(response.headerHtml);
                    }

                    // Update content area
                    $('#frameData').html(renderTable(response));
                    renderPagination(response.paginationLinks);

                    // Initialize components once
                    initializeComponents(response);
                    
                    // Apply frame grouping if active
                    if (frameGroupingActive) {
                        $('#frameGrouping').prop('checked', true).trigger('change');
                    }
                    
                    scrollToTop();
                     // Hide toggle button for child rows and apply grouping state
                     hideToggleButtonForChildRows();
                     applyGroupingState();

                     // Enable/disable tier dropdown based on checkbox state
                    const rows = document.querySelectorAll("tr[data-model-id]");
                    rows.forEach(row => {
                        const checkboxes = row.querySelectorAll(".package-checkbox");
                        const tierDropdown = row.getElementsByClassName("tier-dropdown")[0];
                        function updateDropdownState() {
                            const isAnyChecked = Array.from(checkboxes).some(checkbox => checkbox.checked);
                            tierDropdown.disabled = !isAnyChecked;
                        }
                        updateDropdownState();
                        checkboxes.forEach(checkbox => {
                            checkbox.addEventListener("change", updateDropdownState);
                        });
                    });
                },
                error: function(xhr, status, error) {
                    console.error("Error loading data:", error);
                    $('#frameData').html('<p>Error loading data</p>');
                },
            });
        }

        const initializeComponents = function(response) {
            // Destroy existing selectpickers to prevent multiple initializations
            $('.selectpicker').selectpicker('destroy');

            // Initialize dropdowns
            $('.selectpicker').selectpicker({
                        container: '#frame_tab'
            });

            // Prevent Bootstrap from handling selectpicker dropdowns
            $(document).on('click', '.bootstrap-select .dropdown-toggle', function(e) {
                                e.stopPropagation();
                            });

            // Setup column visibility
            if (response.columns && response.columns.length) {
                setupColumnVisibilityDropdown(response.columns);
            }

            // Initialize event handlers (with proper unbinding)
            initializeEventHandlers();

            // Enable/disable tier dropdowns based on checkbox state
            initializeTierDropdowns();
        }

        const initializeEventHandlers = function() {
            // Remove all existing handlers first
            $(document).off('change', '#packageDropdown')
                       .off('change', '#priceDropdown')
                       .off('change', '#manufacturerDropdown')
                       .off('change', '#brandDropdown')
                       .off('change', '#modelDropdown')
                       .off('click', '#resetButton')
                       .off('change', '#frameGrouping')
                       .off('click', '#loadFrameGrid')
                       .off('change', '.tier-dropdown')
                       .off('change', '.charge-dropdown')
                       .off('change', '.package-checkbox')
                       .off('change', '#statusDropdown')
                       .off('click', '.filter-btn'); // Add this line to unbind previous handlers

            // Filter button click handler
            $(document).on('click', '.filter-btn', function(event) {
                event.stopPropagation(); // Prevent event from bubbling up and closing other dropdowns
                const columnIndex = $(this).data('column-index');
                const th = $(this).closest('th')[0]; // Get the actual TH DOM element
                showFilterDropdown(columnIndex, th);
            });

            // Close filter dropdown when clicking anywhere else on the document
            $(document).on('click', function(event) {
                const dropdown = document.getElementById('filter-dropdown');
                if (dropdown && dropdown.style.display === 'block' && !dropdown.contains(event.target) && !$(event.target).hasClass('filter-btn') && !$(event.target).closest('.filter-btn').length) {
                    closeFilterDropdown();
                }
            });

            // Package dropdown
            $(document).on('change', '#packageDropdown', function(event) {
                event.stopPropagation();
                handlePackageStorage();
                loadFrameGrid(null, $(this).val(), null, null, null, "package");
            });

            // Price dropdown
            $(document).on('change', '#priceDropdown', function(event) {
                event.stopPropagation();
                handlePriceFilterStorage();
                loadFrameGrid($(this).val(), null, null, null, null, "price");
            });

            // Manufacturer dropdown
            $(document).on('change', '#manufacturerDropdown', function(event) {
                event.stopPropagation();
                handleManufacturerStorage();
                loadFrameGrid(null, null, $(this).val(), null, null, "manufacturer");
            });

            // Brand dropdown
            $(document).on('change', '#brandDropdown', function(event) {
                event.stopPropagation();
                handleBrandStorage();
                loadFrameGrid(null, null, null, $(this).val(), null, "brand");
            });

            // Model dropdown
            $(document).on('change', '#modelDropdown', function(event) {
                event.stopPropagation();
                handleModelStorage();
                loadFrameGrid(null, null, null, null, $(this).val(), "model");
            });

              // Status dropdown
            $(document).on('change', '#statusDropdown', function(event) {
                event.stopPropagation();
                handleStatusFilterStorage();
                loadFrameGrid(null, null, null, null, null, $(this).val(), "status");
            });

            // Reset button
            $(document).on('click', '#resetButton', function(event) {
                event.preventDefault();
                localStorage.removeItem('selectedManufacturerId');
                localStorage.removeItem('selectedBrandId');
                localStorage.removeItem('selectedModelName');
                localStorage.removeItem('frameGroupingActive');
                localStorage.removeItem('selectedPackageId');
                localStorage.removeItem('selectedPriceFilterId');
                localStorage.removeItem('selectedStatusFilterId');
                loadFrameGrid(); // Load with all filters cleared
            });

            $(document).on('change', '#frameGrouping', function () {
                populateGroupedRows();
                const isGroupingActive = $(this).is(':checked');
                
                if (isGroupingActive) {
                    localStorage.setItem('frameGroupingActive', 1);
                    
                    // First pass: count model occurrences
                    const modelCounts = {};
                    $('tr[data-model-id]').each(function() {
                        const modelId = $(this).data('model-id');
                        modelCounts[modelId] = (modelCounts[modelId] || 0) + 1;
                    });
                    
                    // Second pass: apply grouping
                    $('tr[data-model-id]').each(function() {
                        const modelId = $(this).data('model-id');
                        const rows = groupedRows[modelId] || [];
                        const toggleButton = $(this).find('.group-toggle-btn');
                        
                        // Only show toggle for models with multiple rows
                        if (modelCounts[modelId] > 1) {
                            // For first row of each group
                            if (rows[0] && rows[0].is($(this))) {
                                toggleButton.text('+').show(); // Show + when collapsed
                                toggleButton.data('expanded', false);
                                
                                // Hide subsequent rows
                                for (let i = 1; i < rows.length; i++) {
                                    rows[i].hide().addClass('highlighted');
                                    rows[i].find('.group-toggle-btn').hide();
                                }
                                
                                // Add count indicator
                                if (!toggleButton.find('.collapsed-count').length) {
                                    let countSpan = $("<span>")
                                        .addClass("collapsed-count")
                                        .text(` (${rows.length})`);
                                    toggleButton.append(countSpan);
                                }
                            } else {
                                toggleButton.hide();
                            }
                            
                            // Style the first row
                            if (rows[0] && rows[0].is($(this))) {
                                $(this).css('background-color', 'lightgray');
                            }
                        } else {
                            // Single row - hide toggle button completely
                            toggleButton.hide();
                            $(this).css('background-color', '');
                        }
                    });
                } else {
                    localStorage.removeItem('frameGroupingActive');
                    
                    // Show all rows first
                    $('tr[data-model-id]').show()
                        .css('background-color', '')
                        .removeClass('highlighted');
                        
                    // Then handle toggle buttons for ungrouped state
                    Object.keys(groupedRows).forEach(modelId => {
                        const rows = groupedRows[modelId];
                        if (rows.length > 1) {
                            // Only show - on first row of each group
                            rows[0].find('.group-toggle-btn')
                                .text('-')
                                .show()
                                .find('.collapsed-count').remove();
                            
                            // Hide toggle buttons for all other rows in group
                            for (let i = 1; i < rows.length; i++) {
                                rows[i].find('.group-toggle-btn').hide();
                            }
                        } else {
                            // Hide toggle for single rows
                            rows[0].find('.group-toggle-btn').hide();
                        }
                    });
                }
            });
        }

        const initializeTierDropdowns = function() {
            $("tr[data-model-id]").each(function() {
                const checkboxes = $(this).find(".package-checkbox");
                const tierDropdown = $(this).find(".tier-dropdown");
                
                function updateDropdownState() {
                    const isAnyChecked = checkboxes.is(':checked');
                    tierDropdown.prop('disabled', !isAnyChecked);
                    
                    if (!isAnyChecked) {
                        tierDropdown.val(0);
                    } else if (tierDropdown.val() == 0) {
                        tierDropdown.val(1); // Default to first tier if none selected
                    }
                }
                
                // Initialize state
                updateDropdownState();
                
                // Bind change events
                checkboxes.on('change', updateDropdownState);
            });
        }
        let columnFilters = {};

        const renderTable = function(response) {
            if (response.stylesCollection.length === 0) {
                return '';
            }
            const headers = response.columns;
            const noFilterColumns = [
                '  ',
                'Packages',
                'Tier',
                'Price',
                'Charge',
                'Non-Rx',
                'Out-Edge'
            ];
            // Generate table header HTML
            const headerHtml = headers.map((header, index) => {
                if (noFilterColumns.includes(header.name)) {
                    return `<th class="filter-th" ${header.width ? ` width="${header.width}"` : ''}>${header.name}</th>`;
                }
                return `<th class="filter-th" ${header.width ? ` width="${header.width}"` : ''}>${header.name} <button class="btn btn-light btn-sm filter-btn" data-column-index="${index}"><i class="fa fa-caret-down"></i></button></th>`;
            }).join('');

            // Start building table
            let tableHtml = `
                <table class="table-container table-striped table-sm table-hover w-auto data-table extend-class" id="frameTable">
                    <thead class="thead-dark">
                        <tr class="p-3 mb-2 bg-primary text-white">
                            ${headerHtml}
                        </tr>
                    </thead>
                    <tbody>
            `;
            // Generate rows
            tableHtml += response.stylesCollection.data.map(style => {
                style.frame_style_data = JSON.parse(style.frame_style_data);
                return generateTableRow(style, response);
            }).join('');

            tableHtml += '</tbody></table>';

            return tableHtml;
        }

        const showFilterDropdown = function(columnIndex, th) {
            console.log('showFilterDropdown called for column:', columnIndex, 'from element:', th);
            let dropdown = document.getElementById('filter-dropdown');
            if (!dropdown) {
                dropdown = document.createElement('div');
                dropdown.id = 'filter-dropdown';
                dropdown.className = 'filter-dropdown';
                // Add essential styling for visibility and positioning
                dropdown.style.position = 'absolute';
                dropdown.style.zIndex = '10000'; // A very high z-index to ensure it's on top
                dropdown.style.backgroundColor = '#fff'; // White background
                dropdown.style.border = '1px solid #ccc'; // Light gray border
                dropdown.style.boxShadow = '0 2px 10px rgba(0,0,0,0.1)'; // Subtle shadow
                dropdown.style.minWidth = '200px'; // Ensure it has a minimum width
                document.body.appendChild(dropdown);
            }

            const table = document.getElementById('frameTable');
            const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');
            const uniqueValues = new Set();

            for (let i = 0; i < rows.length; i++) {
                const cell = rows[i].getElementsByTagName('td')[columnIndex];
                if (cell) {
                    uniqueValues.add(cell.textContent || cell.innerText);
                }
            }

            const existingFilter = columnFilters[columnIndex];

            let dropdownHtml = `
                <div class="filter-dropdown-content">
                    <input type="text" class="form-control form-control-sm" onkeyup="filterDropdownSearch(this, ${columnIndex})" placeholder="Search...">
                    <div class="filter-dropdown-items">
                        <div><input type="checkbox" onchange="toggleSelectAll(this, ${columnIndex})" ${!existingFilter || existingFilter.size === uniqueValues.size ? 'checked' : ''}> (Select All)</div>
            `;

            uniqueValues.forEach(value => {
                const isChecked = !existingFilter || existingFilter.has(value);
                dropdownHtml += `<div><input type="checkbox" class="filter-item" value="${value}" ${isChecked ? 'checked' : ''}> ${value}</div>`;
            });

            dropdownHtml += `
                    </div>
                    <div class="filter-dropdown-buttons">
                        <button class="btn btn-primary btn-sm" onclick="applyColumnFilter(${columnIndex})">Apply</button>
                        <button class="btn btn-secondary btn-sm" onclick="clearColumnFilter(${columnIndex})">Clear</button>
                        <button class="btn btn-secondary btn-sm" onclick="closeFilterDropdown()">Cancel</button>
                    </div>
                </div>
                `;

            dropdown.innerHTML = dropdownHtml;
            dropdown.style.display = 'block';
            const rect = th.getBoundingClientRect();
            dropdown.style.left = rect.left + 'px';
            dropdown.style.top = rect.bottom + 'px';
        }

        const filterDropdownSearch = function(input, columnIndex) {
            const filter = input.value.toUpperCase();
            const dropdown = document.getElementById('filter-dropdown');
            const items = dropdown.getElementsByClassName('filter-item');

            for (let i = 0; i < items.length; i++) {
                const value = items[i].value;
                if (value.toUpperCase().indexOf(filter) > -1) {
                    items[i].parentElement.style.display = "";
                } else {
                    items[i].parentElement.style.display = "none";
                }
            }
        }

        const toggleSelectAll = function(checkbox, columnIndex) {
            const dropdown = document.getElementById('filter-dropdown');
            const items = dropdown.getElementsByClassName('filter-item');
            for (let i = 0; i < items.length; i++) {
                items[i].checked = checkbox.checked;
            }
        }

        const applyColumnFilter = function(columnIndex) {
            const dropdown = document.getElementById('filter-dropdown');
            const items = dropdown.getElementsByClassName('filter-item');
            const selectedValues = new Set();

            for (let i = 0; i < items.length; i++) {
                if (items[i].checked) {
                    selectedValues.add(items[i].value);
                }
            }

            columnFilters[columnIndex] = selectedValues;

            const table = document.getElementById('frameTable');
            const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

            for (let i = 0; i < rows.length; i++) {
                const cell = rows[i].getElementsByTagName('td')[columnIndex];
                if (cell) {
                    const cellValue = cell.textContent || cell.innerText;
                    if (selectedValues.has(cellValue)) {
                        rows[i].style.display = "";
                    } else {
                        rows[i].style.display = "none";
                    }
                }
            }

            const th = document.querySelector(`.filter-th:nth-child(${columnIndex + 1})`);
            const filterBtn = th.querySelector('.filter-btn i');
            filterBtn.classList.remove('fa-caret-down');
            filterBtn.classList.add('fa-filter');

            closeFilterDropdown();
        }

        const clearColumnFilter = function(columnIndex) {
            delete columnFilters[columnIndex];

            const table = document.getElementById('frameTable');
            const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

            for (let i = 0; i < rows.length; i++) {
                rows[i].style.display = "";
            }

            const th = document.querySelector(`.filter-th:nth-child(${columnIndex + 1})`);
            const filterBtn = th.querySelector('.filter-btn i');
            filterBtn.classList.remove('fa-filter');
            filterBtn.classList.add('fa-caret-down');

            closeFilterDropdown();
        }

        const closeFilterDropdown = function() {
            const dropdown = document.getElementById('filter-dropdown');
            dropdown.style.display = 'none';
        }

        // Helper function to generate a single table row
        const generateTableRow = function(style, response) {
            const packageCheckboxes = Object.entries(response.packageCollection)
                .map(([key, value]) => {
                    const isChecked = style.package_data && 
                        JSON.parse(style.package_data).hasOwnProperty(key) && 
                        style.model_id === style.model_id;
                    
                    return `
                        <div class="table-cell" style="flex: 1; padding: 5px;">
                            <input 
                                data-package-id="${key}"
                                data-manufacturer-id="${style.manufacturer_id}"
                                data-brand-id="${style.brand_id}"
                                data-model-id="${style.model_id}"
                                configurationFPC="${style.frame_style_data.ConfigurationFPC}"
                                type="checkbox"
                                name="selected_items"
                                value="${value}"
                                class="form-check-input package-checkbox"
                                ${isChecked ? 'checked' : ''}>
                        </div>
                        <div class="table-cell" style="flex: 2; padding: 5px;">${value}</div>
                    `;
                }).join('');

            const tierOptions = Object.entries(response.tierCollection)
                .map(([id, value]) => 
                    `<option class="tier-price-save" name="${value}" value="${id}" ${id === style.tier ? 'selected' : ''}>${value}</option>`
                ).join('');

            const chargeOptions = Object.entries(response.chargeCollection)
                .map(([id, value]) => 
                    `<option class="tier-price-save" name="${value}" value="${id}" ${id === style.charge ? 'selected' : ''}>${value}</option>`
                ).join('');


            // Helper function to check if field exists in frame_style_data
            const isFieldInFrameData = (style, field) => {
                return style.frame_style_data && 
                    style.frame_style_data.hasOwnProperty(field) && 
                    style.frame_style_data[field] !== '' && 
                    style.frame_style_data[field] !== null;
            };

            // Helper function to create editable measurement fields
            const createEditableField = (style, fieldName) => {
                const value = isFieldInFrameData(style, fieldName) 
                    ? style.frame_style_data[fieldName] 
                    : style[fieldName];
                
                // Always make editable if not in frame_style_data
                if (!isFieldInFrameData(style, fieldName)) {
                    return `<input type="text" 
                                class="editable-frame-field" 
                                data-field="${fieldName}"
                                value="${value || ''}" 
                                style="width: 50px;">`;
                }
                return value;
            };

            return `
                <tr data-model-id="${style.model_id}" configurationFPC="${style.frame_style_data.ConfigurationFPC}" class="frameRow">
                    <td><button class="group-toggle-btn"></button></td>
                    <td>
                        <div class="table-sm nested-table" style="display: flex; flex-wrap: wrap;">
                            <div class="table-row" style="display: flex; width: auto;">
                                ${packageCheckboxes}
                            </div>
                        </div>
                    </td>
                    <td class="tier-selector">
                        <select name="tier_selector" class="tier-dropdown" id="tier-dropdown">
                            <option value="0">-</option>
                            ${tierOptions}
                        </select>
                    </td>
                    <td><input class="input-class-price" type="text" name="price" value="${style.price ? formatPrice(style.price) : ''}"></td>
                    <td class="charge-selector">
                        <select name="charge_selector" class="charge-dropdown">
                            <option value="0">-</option>
                            ${chargeOptions}
                        </select>
                    </td>
                    <td><input type="checkbox" name="non_rx" class="non-rx-checkbox" ${style.non_rx == '1' ? 'checked' : ''}></td>
                    <td><input type="checkbox" name="out_edge" class="out-edge-checkbox" ${style.out_edge == '1' ? 'checked' : ''}></td>
                    <td>${cleanText(style.frame_style_data.ManufacturerName)}</td>
                    <td>${cleanText(style.frame_style_data.BrandName)}</td>
                    <td class="model-id" model_value="${style.model_id}">${cleanText(style.name)}</td>
                    <td>${style.frame_style_data.FrameColor || ''}</td>
                    <td>${formatSize(style.frame_style_data)}</td>
                    <td>${style.frame_style_data.FrameColorCode || ''}</td>
                    <td>${createEditableField(style, 'A')}</td>
                    <td>${createEditableField(style, 'B')}</td>
                    <td>${createEditableField(style, 'ED')}</td>
                    <td>${createEditableField(style, 'DBL')}</td>
                    <td>${style.frame_style_data.EDAngle || ''}</td>
                    <td>${style.frame_style_data.Rim || ''}</td>
                    <td>${style.frame_style_data.EdgeType || ''}</td>
                    <td><a onclick="showFrameImage(this)" mid="${style.manufacturer_id}" upc="${style.frame_style_data.UPC}">Show</a></td>
                    <td configurationFPC="${style.frame_style_data.ConfigurationFPC}">${style.frame_style_data.ConfigurationFPC || ''}</td>
                    <td>${style.frame_style_data.UPC || ''}</td>
                    <td>${style.frame_style_data.SKU || ''}</td>
                    <td>${style.status || ''}</td>
                    <td>${style.frame_style_data.Material || ''}</td>
                    <td>${style.frame_style_data.PreciousMetal || ''}</td>
                    <td>${cleanText(style.frame_style_data.FrameShape) || ''}</td>
                    <td>${style.frame_style_data.RX || ''}</td>
                    <td>${style.frame_style_data.FrameType || ''}</td>
                    <td>${style.frame_style_data.LensColor || ''}</td>
                    <td>${style.frame_style_data.LensColorCode || ''}</td>
                </tr>
            `;
        }

        // Helper function to format size string
        const formatSize = function(frameData) {
            const parts = [
                frameData.EyeSize,
                frameData.BridgeSize,
                frameData.TempleLength
            ].filter(Boolean);
            return parts.length ? parts.join(' - ') : '';
        }

        const scrollToTop = function() {
            document.getElementById('frameContent').scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        }

        const renderPagination = function(paginationLinks) {
            $('#pagination-links').html(paginationLinks);
        }

        $('#pagination-links').on('click', 'a', function (e) {
            e.preventDefault();
            const pageUrl = $(this).attr('href');
            loadFrameGrid(null, null, null, null, null, null, null, pageUrl);
        });

        // Function to save the current column visibility state to localStorage
        const saveColumnVisibilityState = function() {
            const checkboxes = document.querySelectorAll('.column-checkbox');
            const visibilityState = {};
            checkboxes.forEach(checkbox => {
                visibilityState[checkbox.dataset.columnName] = checkbox.checked;
            });
            localStorage.setItem('columnVisibility', JSON.stringify(visibilityState));
        }

        // Function to load the column visibility state from localStorage
        const loadColumnVisibilityState = function() {
            const savedState = localStorage.getItem('columnVisibility');
            return savedState ? JSON.parse(savedState) : null;
        }

        // Column visibility dropdown that stays open when clicking checkboxes
        const setupColumnVisibilityDropdown = function(columns) {
            if(columns === undefined) return;
            // Remove existing dropdown if it exists
            const existingDropdown = document.getElementById('columnVisibilityDropdownContainer');
            if (existingDropdown) {
                existingDropdown.remove();
            }
            // Create main dropdown container
            const dropdownContainer = document.createElement('div');
            dropdownContainer.className = 'dropdown';
            dropdownContainer.style.display = 'inline-block';
            dropdownContainer.style.marginLeft = '10px';
            dropdownContainer.style.position = 'relative';
            dropdownContainer.style.zIndex = '1000';
            dropdownContainer.id = 'columnVisibilityDropdownContainer';

            // Create dropdown button
            const dropdownButton = document.createElement('button');
            dropdownButton.className = 'btn btn-secondary dropdown-toggle';
            dropdownButton.type = 'button';
            dropdownButton.id = 'columnVisibilityDropdown';
            dropdownButton.setAttribute('aria-expanded', 'false');
            dropdownButton.textContent = 'Columns';
            
            // Create dropdown menu
            const dropdownMenu = document.createElement('div');
            dropdownMenu.className = 'dropdown-menu dropdown-menu-right';
            dropdownMenu.setAttribute('aria-labelledby', 'columnVisibilityDropdown');
            dropdownMenu.style.padding = '10px';
            dropdownMenu.style.width = '250px';
            dropdownMenu.style.maxHeight = '400px';
            dropdownMenu.style.overflowY = 'auto';

            const savedState = loadColumnVisibilityState();

            // Add checkboxes for each column
            columns.forEach((column) => {
                if (column.id === 'toggle') return;

                const checkboxContainer = document.createElement('div');
                checkboxContainer.className = 'form-check';

                const checkbox = document.createElement('input');
                checkbox.className = 'form-check-input column-checkbox';
                checkbox.type = 'checkbox';
                checkbox.value = column.id;
                checkbox.id = `checkbox-${column.id}`;
                checkbox.checked = savedState ? savedState[column.name] !== false : true; // Default to true if not in saved state
                checkbox.dataset.columnName = column.name;
                const label = document.createElement('label');
                label.className = 'form-check-label';
                label.htmlFor = `checkbox-${column.id}`;
                label.textContent = column.name;
                label.style.cursor = 'pointer';

                checkboxContainer.appendChild(checkbox);
                checkboxContainer.appendChild(label);
                dropdownMenu.appendChild(checkboxContainer);
            });

            dropdownContainer.appendChild(dropdownButton);
            dropdownContainer.appendChild(dropdownMenu);

            // Add the dropdown to the header
            const headerContainer = document.querySelector('.header-container .right');
            if (headerContainer) {
                headerContainer.insertBefore(dropdownContainer, headerContainer.firstChild);
            }

            // Initialize Bootstrap dropdown
            if (typeof bootstrap !== 'undefined') {
                const dropdown = new bootstrap.Dropdown(dropdownButton);

                // Prevent dropdown from closing when clicking checkboxes
                dropdownMenu.addEventListener('click', function(e) {
                    if (e.target.classList.contains('column-checkbox')) {
                        e.stopPropagation();
                    }
                });
            } else {
                // Fallback for when Bootstrap JS isn't available
                dropdownButton.addEventListener('click', function(e) {
                    e.stopPropagation();
                    const isShown = dropdownMenu.style.display === 'block';
                    dropdownMenu.style.display = isShown ? 'none' : 'block';
                });

                // Close when clicking outside
                document.addEventListener('click', function() {
                        dropdownMenu.style.display = 'none';
                                    });

                // Prevent closing when clicking inside dropdown
                dropdownMenu.addEventListener('click', function(e) {
                    e.stopPropagation();
                });
            }

            // Event delegation for checkbox changes
            document.addEventListener('change', function(e) {
                if (e.target.classList.contains('column-checkbox')) {
                    const columnName = e.target.dataset.columnName;
                    const isVisible = e.target.checked;
                    toggleColumnVisibility(columnName, isVisible);
                    saveColumnVisibilityState(); // Save state on change
                }
            });

            // Initialize all columns as visible
            initializeAllColumns();
        }

        // Function to toggle column visibility using event delegation
        const toggleColumnVisibility = function(columnName, isVisible) {
            const table = document.getElementById('frameTable');
            if (!table) return;

            // Find all headers that match the column name
            const headers = Array.from(table.querySelectorAll('thead th')).filter(header => {
                // return header.textContent.trim().toLowerCase().includes(columnName.toLowerCase());
                return header.textContent.includes(columnName);
            });

            headers.forEach(header => {
                const columnIndex = Array.from(header.parentElement.children).indexOf(header);
                header.style.display = isVisible ? '' : 'none';

                // Toggle corresponding cells in all rows
                const rows = table.querySelectorAll('tbody tr');
                rows.forEach(row => {
                    const cells = row.querySelectorAll('td');
                    if (cells[columnIndex]) {
                        cells[columnIndex].style.display = isVisible ? '' : 'none';
                    }
                });
            });
        }

        // Initialize all columns as visible
        const initializeAllColumns = function() {
            const checkboxes = document.querySelectorAll('.column-checkbox');
            checkboxes.forEach(checkbox => {
                const columnName = checkbox.dataset.columnName;
                toggleColumnVisibility(columnName, checkbox.checked);
            });
        }

        // Modified initialization
        const initializeColumnVisibilitySystem = function() {
            if (typeof bootstrap === 'undefined' && typeof jQuery !== 'undefined') {
                jQuery(document).ready(function() {
                    setupColumnVisibilityDropdown();
                });
            } else {
                if (document.getElementById('frameTable')) {
                    setupColumnVisibilityDropdown();
                }

                const observer = new MutationObserver(function(mutations) {
                    if (document.getElementById('frameTable') && !document.getElementById('columnVisibilityDropdownContainer')) {
                        setupColumnVisibilityDropdown();
                    }
                });

                observer.observe(document.body, { childList: true, subtree: true });
            }
        }

        // Initialize with DOMContentLoaded or when table exists
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded',                 initializeColumnVisibilitySystem);
        } else {
            initializeColumnVisibilitySystem();
        }

        // Make functions global
        window.exportToCSV = exportToCSV;
        window.loadFrameGrid = loadFrameGrid;
        window.importInHouseModel = importInHouseModel;
        window.showFrameImage = showFrameImage;
        window.initializeDropdownHandlers = initializeDropdownHandlers;
        window.handlePackageCheckboxChange = handlePackageCheckboxChange;
        window.renderTable = renderTable;
        window.showFilterDropdown = showFilterDropdown;
        window.filterDropdownSearch = filterDropdownSearch;
        window.toggleSelectAll = toggleSelectAll;
        window.applyColumnFilter = applyColumnFilter;
        window.clearColumnFilter = clearColumnFilter;
        window.closeFilterDropdown = closeFilterDropdown;
        window.generateTableRow = generateTableRow;
        window.formatSize = formatSize;
        window.scrollToTop = scrollToTop;
        window.renderPagination = renderPagination;
        window.saveColumnVisibilityState = saveColumnVisibilityState;
        window.loadColumnVisibilityState = loadColumnVisibilityState;
        window.setupColumnVisibilityDropdown = setupColumnVisibilityDropdown;
        window.toggleColumnVisibility = toggleColumnVisibility;
        window.initializeAllColumns = initializeAllColumns;
        window.initializeColumnVisibilitySystem = initializeColumnVisibilitySystem;
        window.formatPrice = formatPrice;
        window.cleanText = cleanText;
        window.frameGroupingIsActive = frameGroupingIsActive;
        window.formatTimestamp = formatTimestamp;
        window.hideToggleButtonForChildRows = hideToggleButtonForChildRows;
        window.populateGroupedRows = populateGroupedRows;
        window.handleChangeEvent = handleChangeEvent;
        window.initializeComponents = initializeComponents;
        window.initializeEventHandlers = initializeEventHandlers;
        window.initializeTierDropdowns = initializeTierDropdowns;
        window.applyGroupingState = applyGroupingState;
    }

if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded',         init);
} else {
    init();  // DOM is already ready—run now
}
