$(function() {
    // Sidepanel Order module
    (function () {
        var order = {
            _init: function() {
                this._cacheDom();
                this._bindEvents();
                this._render();
            },
            _cacheDom: function() {
                this.body = $('body');
                this.element = $(document).find('.table-data-container');
                this.sidePanel = $(document).find('#sidebar-order_panel');
            },
            _bindEvents: function() {
                this.body.on('click', this.closeSidePanel.bind(this));
                // this.sidePanel.on('click', this.preventClose.bind(this));
                // this.body.find('#overlay').on('click', this.turnOffOverlay.bind(this));
                $(document).on('click','.view-order', this.viewOrder.bind(this));
                this.sidePanel.find('#open-panel').on('click', this.openSidePanel.bind(this));
                $(document).on('click','.fullscreen', this.forceCloseSidePanel.bind(this));
            },
            _render: function(response) {
                this.sidePanel.find('#side-order_content').empty();
                this.sidePanel.find('#side-order_content').append($(response));
            },
    
            viewOrder: function(e) {
                container = this;
                e.preventDefault();
                $.ajax({
                    url: $(e.target).attr('data-url'),
                    method: "POST",
                    processData: false,
                    contentType : false,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                })
                .done(function(response) {
                    container._render(response);
                    container.openSidePanel();
                    container.turnOnOverlay();
                })
            },

            openSidePanel: function() {
                this.sidePanel.find('#rightMenu').css('display','block');
            },

            closeSidePanel: function(event) {
                if(!$(event.target).is("#overlay, #overlay *")) return;
                this.sidePanel.find('#rightMenu').css('display','none');
                this.body.find('#overlay').css('display','none');
            },

            forceCloseSidePanel: function(event) {
                this.sidePanel.find('#rightMenu').css('display','none');
                this.body.find('#overlay').css('display','none');
            },

            turnOnOverlay: function() {
                this.body.find('#overlay').css('display','block')
            },
            
            turnOffOverlay: function() {
                this.body.find('#overlay').css('display','none')
            },

            preventClose: function() {
                this.sidePanel.find('#rightMenu').css('display','block');
            },
        };
        order._init();
    })();
});