// Scroll functionality extracted from my-custom.js and order-list.js

// Scroll functions from my-custom.js
$('.nscroller').each(function(){
    // Use default browser scrollbar with debounced scroll handler
    const debouncedScroll = debounce((event) => {
        const element = event.target;
        if ($(element).hasClass('table-data-container') &&
            element.scrollTop + element.clientHeight >= element.scrollHeight - 10) {
            $('#load-more-btn').trigger('click');
        }
    }, 250);
    $(this)[0].addEventListener('scroll', debouncedScroll);
});

var myScrollFunc = function () {
    if($('.table-data-container').length > 0){
        let containerHeight = $('.table-data-container').height();
        let max = containerHeight + 64;
        let scroll = 0;
        if($(window).scrollTop() >= 125 && $(window).scrollTop() + $(window).height() <= max)
        {
            scroll = $(window).scrollTop()-125;
        }else if($(window).scrollTop() > 125 && $(window).scrollTop() + $(window).height() > max){
            scroll = containerHeight - documentHeight - 90;
        }
        // $('#order-details-container').css('margin-top',scroll+'px');
    }
    if($('.rx-summary-container').length > 0 && !isMobile){
        let scroll = $(window).scrollTop();
        if(($(window).scrollTop() + 800) > $('.rx-form-content').height()){
            scroll = $('.rx-form-content').height() - 820;
        }
        $('.rx-summary-container').css('margin-top',scroll+'px');
    }
};
window.addEventListener("scroll", myScrollFunc);
window.addEventListener("scroll", myScrollFunc);
$(window).scroll(function() {
   if($(window).scrollTop() + $(window).height() == $(document).height()) {
        if(!$('#load-more-btn').hasClass('not-allowed'))
            $('#load-more-btn').trigger('click');
   }
});

// Scroll functions from order-list.js
(function() {
    function init() {
        let currentPage = 1;
        const recordsPerPage = 200;
        let isLoading = false;
        let nextPage = 2;
        let totalRecords = 0;
        let loadedRecords = 0;
        let pageCache = {};

        // Initialize with server-rendered content
        const initialRows = document.querySelectorAll('#records-container tbody tr');
        loadedRecords = initialRows.length;

        // Set up scroll listener for the scrollable container (parent of #records-container or #records-container itself)
        const recordsContainer = document.querySelector('#records-container');
        const scrollableContainer = recordsContainer ? recordsContainer.parentElement || recordsContainer : null;
        if (scrollableContainer) {
            scrollableContainer.addEventListener('scroll', function () {
                checkScroll();
            });
        }

        // Get total records from hidden field or data attribute
        totalRecords = parseInt(document.querySelector('#total-records')?.value) || 0;

        // Call onPageLoad to handle initial data fetching
        onPageLoad();

        // Check if the container is scrollable
        if (scrollableContainer) {
            scrollableContainer.addEventListener('scroll', checkIfScrollable);
        }

        // Check for scrolling to the bottom inside the scrollable container
        function checkScroll() {
            if (!scrollableContainer || isLoading) return;

            const scrollTop = scrollableContainer.scrollTop;
            const containerHeight = scrollableContainer.clientHeight;
            const scrollHeight = scrollableContainer.scrollHeight;

            // Trigger loading at 50% of scroll height
            if (scrollTop + containerHeight >= scrollHeight * 0.5) {
                if (totalRecords === 0 || loadedRecords < totalRecords) {
                    isLoading = true;
                    loadNextPage();
                }
            }
        }

        // Load the next page of records
        function loadNextPage() {
            const scrollPositionBeforeLoad = scrollableContainer.scrollTop;

            const url = $('#orders_search_form').attr('action');
            const data = $('#orders_search_form').serializeArray();
            data.push({ name: 'page-no', value: nextPage });
            data.push({ name: 'records-per-page', value: recordsPerPage });

            $.ajax({
                url: url,
                type: 'POST',
                data: $.param(data),
                success: function (response) {
                    if (response && response.html) {
                        const previousHeight = scrollableContainer.scrollHeight;
                        const tbodyContent = $(response.html).find('tbody').html();

                        if (tbodyContent) {
                            $('#records-container tbody').append(tbodyContent);
                            loadedRecords += response.loadedRecords || recordsPerPage;
                            totalRecords = response.totalRecords || totalRecords;
                            nextPage++;

                            // Update total records hidden field
                            const totalRecordsField = document.querySelector('#total-records');
                            if (totalRecordsField) {
                                totalRecordsField.value = totalRecords;
                            }

                            // Restore scroll position
                            scrollableContainer.scrollTop = scrollPositionBeforeLoad;

                        }
                    }
                    isLoading = false;
                },
                error: function () {
                    isLoading = false;
                },
            });
        }

        // Load records for initial load or search
        function loadRecords() {
            if (isLoading) return;
                isLoading = true;
                const url = $('#orders_search_form').attr('action');
                const data = $('#orders_search_form').serializeArray();
                data.push({ name: 'page-no', value: currentPage });
                data.push({ name: 'records-per-page', value: recordsPerPage });

                $.ajax({
                url: url,
                    type: 'POST',
                    data: $.param(data),
                    success: function (response) {
                        const data = response;
                        const tbodyContent = $(data.html).find('tbody').html();
                        $('#records-container tbody').html(tbodyContent);
                        currentPage = 1;
                        nextPage = 2;
                        totalRecords = data.totalRecords || 0;
                        loadedRecords = data.loadedRecords || 0;

                        // Update total records hidden field
                        const totalRecordsField = document.querySelector('#total-records');
                        if (totalRecordsField) {
                            totalRecordsField.value = totalRecords;
                        }

                        isLoading = false;
                    },
                    error: function () {
                        isLoading = false;
                    },
                });
            }

        // Handle page load and initial data fetching
        function onPageLoad() {
            openSelectedOrder();
            if ($('.split-table').length > 0) {
                loadRecords();
            }
        }

        // Check if the container is scrollable
        function checkIfScrollable() {
            if (scrollableContainer) {
                if (scrollableContainer.scrollHeight > scrollableContainer.clientHeight) {
                    scrollableContainer.classList.add('has-scroll');
                } else {
                    scrollableContainer.classList.remove('has-scroll');
                }
            }
        }

        function openSelectedOrder() {
            const orderList = document.querySelector('.order-list');
            if (orderList) {
                const selectedRow = orderList.querySelector('.split-table tr.selected');
                if (selectedRow) {
                    selectedRow.click();
                }
            }
        }

        function searchOrders(url, data, $searchButton, originalButtonText) {
        if (isLoading) return;
        isLoading = true;

        // Fallback for button if not provided
        if (typeof $searchButton === 'undefined') {
            $searchButton = $('#search_button');
            originalButtonText = '<i class="fa fa-search" aria-hidden="true"></i> Search'; // Default text
        }

        $.ajax({
            url: url,
            type: 'POST',
            data: data,
            success: function (response) {
                console.log('DEBUG: order-list.js searchOrders success response:', response);
                if (response && response.html) {
                        const tbodyContent = $(response.html).find('tbody').html();
                        if (tbodyContent) {
                            document.querySelector('#records-container tbody').innerHTML = tbodyContent;
                        } else {
                            console.error('No tbody content found in the response.');
                        }
                } else {
                    console.error('Invalid response format.');
                }

                $searchButton.prop('disabled', false).html(originalButtonText);
                isLoading = false;

                currentPage = 1;
                nextPage = 2;
                totalRecords = response.totalRecords || 0;
                loadedRecords = response.loadedRecords || 0;

                // Update total records hidden field
                const totalRecordsField = document.querySelector('#total-records');
                if (totalRecordsField) {
                    totalRecordsField.value = totalRecords;
                }

                // Auto-scroll to top of scrollable container
                if (scrollableContainer) {
                    scrollableContainer.scrollTop = 0;
                }
            },
            error: function (error) {
                console.error('DEBUG: order-list.js searchOrders error:', error);
                $searchButton.prop('disabled', false).html(originalButtonText);
                isLoading = false;
                console.error('Error during search:', error);
            },
        });
    }
    }

    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();  // DOM is already ready—run now
    }
})();

// Debounce function
function debounce(func, delay = 250) {
    let timeoutId;
    return function(...args) {
        clearTimeout(timeoutId);
        timeoutId = setTimeout(() => {
            func.apply(this, args);
        }, delay);
    };
}