@extends('backend.layouts.split')

@section('title', __('Api Client') . ' | ' . app_name())

@section('content')
<div class="row row-top-margin">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet light portlet-fit portlet-datatable bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-envelope font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> Api Client </span>
                </div>
            </div>
            <div class="portlet-body">
                <div class="table-toolbar">
                    <div class="row">
                       <div class="col-md-6"></div>
                        <div class="col-md-6">
                            <div class="btn-group float-end">
                                @can('backend admin')
                                    <button id="sample_editable_1_2_new" class="btn sbold green">
                                        <a href="{{ route('admin.auth.api-client.create') }}"  data-toggle="tooltip" title="@lang('labels.general.create_new')" style="color:#fff; text-decoration: none;">Add New </a>
                                        <i class="fa fa-plus"></i>
                                    </button>
                                @endcan
                            </div>
                        </div>
                    </div>
                </div>
                <table class="table table-striped table-bordered table-hover table-checkable order-column table-data_table">
                    <thead>
                        <tr role="row" class="heading">
                            <th width="5%"> # </th>
                            <th width="25%"> Name </th>
                            <th width="20%"> Token </th>
                            <th width="10%"> Rate Limit </th>
                            <th width="10%"> Last used at </th>
                            <th width="10%"> Status </th>
                            <th width="10%">@lang('labels.general.actions')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($model as $value)
                        <tr>
                            <td>{{ $value->id }}</td>
                            <td>{{ $value->name }}</td>
                            <td>
                                <span id="token-{{ $value->id }}" class="d-none">{{ $value->token }}</span>
                                <span id="token-placeholder-{{ $value->id }}">••••••••••••••••</span>
                                <a href="javascript:void(0);" onclick="toggleToken({{ $value->id }})" class="ml-2">
                                    <i class="fa fa-eye" id="eye-icon-{{ $value->id }}"></i>
                                </a>
                                <a href="javascript:void(0);" onclick="copyToken({{ $value->id }}, this)" class="ml-2">
                                    <i class="fa fa-copy" id="copy-icon-{{ $value->id }}"></i>
                                </a>
                            </td>
                            <td>{{ $value->rate_limit }}</td>
                            <td></td>
                            <td>{!! $value->active ? '<span class="label label-sm label-success">Active</span>' : '<span class="label label-sm label-danger">Not Active</span>' !!}</td>
                            <td>
                                <div class="btn-group" role="group" aria-label="'.__('labels.backend.access.users.user_actions').'">  
                                    <a href="{{ route('admin.auth.api-client.edit', $value) }}" title="Edit'" class="btn btn-sm btn-primary"><i class="fa fa-edit"></i></a>
                                        <button class="btn btn-sm green dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false"> 
                                            More
                                            <i class="fa fa-angle-down"></i>
                                        </button>
                                        <ul class="dropdown-menu" role="menu">
                                            <li>
                                                <a href="{{ route('admin.auth.api-client.destroy', $value) }}"
                                                    data-method="delete"
                                                    data-trans-button-cancel="{{ __('buttons.general.cancel') }}"
                                                    data-trans-button-confirm="{{ __('buttons.general.crud.delete') }}"
                                                    data-trans-title="'{{ __('strings.backend.general.are_you_sure') }}"
                                                    class="btn btn-sm dropdown-item"><i class="fa fa-trash-o" aria-hidden="true"></i>
                                                    Delete </a>
                                            </li>
                                        </ul>
                                </div>
                            </td>
                        </tr>                                
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <!-- End: life time stats -->
    </div>
</div>
@endsection
<script>
    function toggleToken(id) {
        const tokenEl = document.getElementById('token-' + id);
        const placeholderEl = document.getElementById('token-placeholder-' + id);
        const eyeIcon = document.getElementById('eye-icon-' + id);

        const isHidden = tokenEl.classList.contains('d-none');

        if (isHidden) {
            tokenEl.classList.remove('d-none');
            placeholderEl.classList.add('d-none');
            eyeIcon.classList.remove('fa-eye');
            eyeIcon.classList.add('fa-eye-slash');
        } else {
            tokenEl.classList.add('d-none');
            placeholderEl.classList.remove('d-none');
            eyeIcon.classList.remove('fa-eye-slash');
            eyeIcon.classList.add('fa-eye');
        }
    }

    function copyToken(id, el) {
        const tokenEl = document.getElementById('token-' + id);
        const token = tokenEl.innerText;

        // Use the modern clipboard API
        navigator.clipboard.writeText(token).then(function() {
            // Success feedback
            const icon = el.querySelector('i');
            const originalIconClass = 'fa-copy';
            const successIconClass = 'fa-check';

            icon.classList.remove(originalIconClass);
            icon.classList.add(successIconClass);

            setTimeout(() => {
                icon.classList.remove(successIconClass);
                icon.classList.add(originalIconClass);
            }, 1500); // Revert after 1.5 seconds
        }).catch(function(err) {
            // Error feedback
            console.error('Failed to copy token: ', err);
            alert('Failed to copy token.');
        });
    }
</script>