@extends('backend.layouts.split')

@section('title', 'Consumables' . ' '.html_entity_decode("&#8212;", ENT_QUOTES, 'UTF-8').' ' . app_name())

@section('content')
<div class="row row-top-margin">
    <div class="col-md-12">
        <!-- Begin: life time stats -->
        <div class="portlet light portlet-fit portlet-datatable bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-basket font-green"></i>
                    <span class="caption-subject font-green sbold uppercase"> Consumables </span>
                </div>
            </div>
            <div class="portlet-body">
                @include('backend.auth.orders.includes.orders-search-form',['orders'=>$orders,'pageCount'=>$pageCount,'orderType'=>$orderType])
                <div class="table-data-container all-orders_container" style="margin-top:5%">
                    @include('partials.orderlist', ['orders' => $orders, 'pageCount' => $pageCount, 'isBackend' => true])
                </div>
                <div class="dt-more-container text-center">
                    <button type="button" class="btn blue mt-ladda-btn ladda-button btn-outline btn-circle" id="load-more-btn" data-style="slide-up" data-spinner-color="#333" data-attr="table-data-container" <?= (!$orders->hasMorePages()) ? 'disabled' : '' ?>>
                        <span class="ladda-label"> <i class="icon-arrow-down"></i>  Load More</span>
                        <span class="ladda-spinner"></span>
                    </button>
                </div>
            </div>
        </div>
        <!-- End: life time stats -->
    </div>
</div>
@include('backend.auth.templates.includes.templates-modal')
@include('backend.auth.orders.includes.side-panel')
@endsection